/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elasticsearch.eventforwarder.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public class NodeCache {
    Logger logger = LoggerFactory.getLogger(NodeCache.class);
    private long MAX_SIZE = 10000L;
    private long MAX_TTL = 5L;
    private volatile NodeDao nodeDao;
    private volatile TransactionOperations transactionOperations;
    private LoadingCache<Long, Map> cache = null;

    public void init() {
        if (this.cache == null) {
            this.logger.info("initializing node data cache (TTL=" + this.MAX_TTL + "m, MAX_SIZE=" + this.MAX_SIZE + ")");
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
            if (this.MAX_TTL > 0L) {
                cacheBuilder.expireAfterWrite(this.MAX_TTL, TimeUnit.MINUTES);
            }
            if (this.MAX_SIZE > 0L) {
                cacheBuilder.maximumSize(this.MAX_SIZE);
            }
            this.cache = cacheBuilder.build((CacheLoader)new CacheLoader<Long, Map>(){

                public Map load(Long key) throws Exception {
                    return NodeCache.this.getNodeAndCategoryInfo(key);
                }
            });
        }
    }

    public Map getEntry(Long key) {
        return (Map)this.cache.getUnchecked((Object)key);
    }

    public void refreshEntry(Long key) {
        this.logger.debug("refreshing node cache entry: " + key);
        this.cache.refresh((Object)key);
    }

    private Map getNodeAndCategoryInfo(final Long nodeId) {
        final HashMap result = new HashMap();
        if (nodeId != null) {
            this.logger.debug("Fetching node data from database into cache");
            this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    OnmsNode node = NodeCache.this.nodeDao.get(nodeId.toString());
                    if (node != null) {
                        NodeCache.this.populateBodyWithNodeInfo(result, node);
                    }
                }
            });
        }
        return result;
    }

    private void populateBodyWithNodeInfo(Map body, OnmsNode node) {
        body.put("nodelabel", node.getLabel());
        body.put("nodesysname", node.getSysName());
        body.put("nodesyslocation", node.getSysLocation());
        body.put("foreignsource", node.getForeignSource());
        body.put("operatingsystem", node.getOperatingSystem());
        StringBuilder categories = new StringBuilder();
        Iterator i = node.getCategories().iterator();
        while (i.hasNext()) {
            categories.append(((OnmsCategory)i.next()).getName());
            if (!i.hasNext()) continue;
            categories.append(",");
        }
        body.put("categories", categories.toString());
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public TransactionOperations getTransactionOperations() {
        return this.transactionOperations;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    public long getMAX_SIZE() {
        return this.MAX_SIZE;
    }

    public void setMAX_SIZE(long MAX_SIZE) {
        this.MAX_SIZE = MAX_SIZE;
    }

    public long getMAX_TTL() {
        return this.MAX_TTL;
    }

    public void setMAX_TTL(long MAX_TTL) {
        this.MAX_TTL = MAX_TTL;
    }
}

