/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dnsresolver.netty;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CaffeineCache<E> {
    private final Cache<String, Entries<E>> cache;

    protected abstract boolean shouldReplaceAll(E var1);

    public CaffeineCache(long maxSize) {
        Caffeine caffeine = Caffeine.newBuilder().expireAfter(new Expiry<String, Entries<E>>(){

            public long expireAfterCreate(String key, Entries<E> value, long currentTime) {
                return TimeUnit.SECONDS.toNanos(value.ttl());
            }

            public long expireAfterUpdate(String key, Entries<E> value, long currentTime, long currentDuration) {
                return Math.min(TimeUnit.SECONDS.toNanos(value.ttl()), currentDuration);
            }

            public long expireAfterRead(String key, Entries<E> value, long currentTime, long currentDuration) {
                return currentDuration;
            }
        }).recordStats();
        if (maxSize > 0L) {
            caffeine.maximumSize(maxSize);
        }
        this.cache = caffeine.build();
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public void clear(String key) {
        this.cache.invalidate((Object)key);
    }

    public Collection<E> get(String key) {
        Entries entries = (Entries)this.cache.getIfPresent((Object)key);
        if (entries == null) {
            return null;
        }
        return entries.get();
    }

    public void cache(String key, E entry, int ttl) {
        Entries<E> entries = (Entries<E>)this.cache.getIfPresent((Object)key);
        if (entries == null) {
            entries = new Entries<E>(ttl);
        }
        entries.add(entry, ttl, this.shouldReplaceAll(entry));
        this.cache.put((Object)key, entries);
    }

    public long size() {
        return this.cache.estimatedSize();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    private static class Entries<E> {
        private final AtomicInteger ttl;
        private final CopyOnWriteArraySet<E> container = new CopyOnWriteArraySet();

        Entries(int initialTtl) {
            this.ttl = new AtomicInteger(initialTtl);
        }

        int ttl() {
            return this.ttl.get();
        }

        void add(E entry, int ttl, boolean shouldReplaceAll) {
            if (shouldReplaceAll) {
                this.container.clear();
            }
            this.container.add(entry);
            this.ttl.updateAndGet(existingTtl -> Math.min(existingTtl, ttl));
        }

        Collection<E> get() {
            return this.container;
        }
    }
}

