/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dnsresolver.netty;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsPtrRecord;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.dnsresolver.netty.ExtendedDnsCache;
import org.opennms.netmgt.dnsresolver.netty.ExtendedDnsCacheEntry;
import org.opennms.netmgt.dnsresolver.netty.NettyDnsResolver;
import org.xbill.DNS.ReverseMap;

public class NettyResolverContext
implements DnsResolver {
    private final NettyDnsResolver parent;
    private final ExtendedDnsCache cache;
    private final Bulkhead bulkhead;
    private final int idx;
    private EventLoopGroup group;
    private DnsNameResolver resolver;

    public NettyResolverContext(NettyDnsResolver parent, ExtendedDnsCache cache, Bulkhead bulkhead, int idx) {
        this.parent = Objects.requireNonNull(parent);
        this.cache = Objects.requireNonNull(cache);
        this.bulkhead = Objects.requireNonNull(bulkhead);
        this.idx = idx;
    }

    public void init() {
        this.group = new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("NettyDnsResolver-NIO-Event-Loop-" + this.idx + "-%d").build());
        this.resolver = new DnsNameResolverBuilder(this.group.next()).channelType(NioDatagramChannel.class).nameServerProvider(this.parent.getNameServerProvider()).queryTimeoutMillis(this.parent.getQueryTimeoutMillis()).maxQueriesPerResolve(1).optResourceEnabled(false).resolveCache((DnsCache)this.cache).build();
    }

    public void destroy() {
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
        if (this.resolver != null) {
            this.resolver.close();
        }
    }

    public CompletableFuture<Optional<InetAddress>> lookup(String hostname) {
        CompletableFuture<Optional<InetAddress>> future = new CompletableFuture<Optional<InetAddress>>();
        this.bulkhead.acquirePermission();
        Future requestFuture = this.resolver.resolve(hostname);
        requestFuture.addListener(responseFuture -> {
            try {
                InetAddress addr = (InetAddress)responseFuture.get();
                future.complete(Optional.ofNullable(addr));
            }
            catch (InterruptedException e) {
                future.completeExceptionally(e);
            }
            catch (ExecutionException e) {
                DnsNameResolverTimeoutException timeoutException = Throwables.getCausalChain((Throwable)e).stream().filter(DnsNameResolverTimeoutException.class::isInstance).map(ex -> (DnsNameResolverTimeoutException)ex).findFirst().orElse(null);
                if (e.getCause() != null) {
                    if (timeoutException != null) {
                        future.completeExceptionally((Throwable)timeoutException);
                    } else if (e.getCause() instanceof UnknownHostException) {
                        future.complete(Optional.empty());
                    } else {
                        future.completeExceptionally(e.getCause());
                    }
                } else {
                    future.completeExceptionally(e);
                }
            }
            finally {
                this.bulkhead.releasePermission();
            }
        });
        return future;
    }

    public CompletableFuture<Optional<String>> reverseLookup(InetAddress inetAddress) {
        CompletableFuture<Optional<String>> future = new CompletableFuture<Optional<String>>();
        String name = ReverseMap.fromAddress((InetAddress)inetAddress).toString();
        List entries = this.cache.get(name, null);
        if (entries != null) {
            Optional<String> cachedHostname = entries.stream().filter(e -> e instanceof ExtendedDnsCacheEntry).map(e -> ((ExtendedDnsCacheEntry)e).hostnameFromPtrRecord()).filter(Objects::nonNull).findFirst();
            if (cachedHostname.isPresent()) {
                return CompletableFuture.completedFuture(Optional.of(NettyResolverContext.removeTrailingDot(cachedHostname.get())));
            }
            return CompletableFuture.completedFuture(Optional.empty());
        }
        this.bulkhead.acquirePermission();
        Future requestFuture = this.resolver.query((DnsQuestion)new DefaultDnsQuestion(name, DnsRecordType.PTR, 1));
        requestFuture.addListener(responseFuture -> {
            try {
                AddressedEnvelope envelope = (AddressedEnvelope)responseFuture.get();
                if (envelope == null) {
                    future.completeExceptionally(new Exception("Got a null envelope!"));
                }
                try {
                    DnsResponse response = (DnsResponse)envelope.content();
                    if (response.code() != DnsResponseCode.NOERROR) {
                        this.cache.cache(name, null, new Exception("Request failed with response code: " + response.code()), this.group.next());
                        future.complete(Optional.empty());
                        return;
                    }
                    DnsPtrRecord ptrRecord = (DnsPtrRecord)response.recordAt(DnsSection.ANSWER);
                    if (ptrRecord == null) {
                        this.cache.cache(name, null, new Exception("No PTR record found."), this.group.next());
                        future.complete(Optional.empty());
                        return;
                    }
                    this.cache.cache(name, ptrRecord, this.group.next());
                    String hostname = ptrRecord.hostname();
                    String trimmedHostname = hostname.substring(0, hostname.length() - 1);
                    future.complete(Optional.of(trimmedHostname));
                    return;
                }
                finally {
                    envelope.release();
                }
            }
            catch (InterruptedException e) {
                future.completeExceptionally(e);
                return;
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    future.completeExceptionally(e.getCause());
                    return;
                }
                future.completeExceptionally(e);
                return;
            }
            finally {
                this.bulkhead.releasePermission();
            }
        });
        return future;
    }

    private static String removeTrailingDot(String hostname) {
        return hostname.substring(0, hostname.length() - 1);
    }
}

