/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.pgshared;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.opennms.features.distributed.kvstore.api.AbstractAsyncKeyValueStore;

public abstract class AbstractPostgresKeyValueStore<T, S>
extends AbstractAsyncKeyValueStore<T> {
    private static final String VALUE_COLUMN = "value";
    private static final String KEY_COLUMN = "key";
    private static final String CONTEXT_COLUMN = "context";
    private static final String LAST_UPDATED_COLUMN = "last_updated";
    private static final String EXPIRES_AT_COLUMN = "expires_at";
    private final DataSource dataSource;

    public AbstractPostgresKeyValueStore(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    private static boolean isExpired(ResultSet resultSet) throws SQLException {
        long now = System.currentTimeMillis();
        Timestamp expiresAt = resultSet.getTimestamp(EXPIRES_AT_COLUMN);
        return expiresAt != null && expiresAt.getTime() < now;
    }

    private PreparedStatement getSelectStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("SELECT %s, %s FROM %s WHERE %s = ? AND %s = ?", VALUE_COLUMN, EXPIRES_AT_COLUMN, this.getTableName(), KEY_COLUMN, CONTEXT_COLUMN));
    }

    private PreparedStatement getUpsertStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("INSERT INTO %s (%s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, " + this.getValueStatementPlaceholder() + ") ON CONFLICT ON CONSTRAINT " + this.getPkConstraintName() + " DO UPDATE SET %s = ?, %s = ?, %s = " + this.getValueStatementPlaceholder(), this.getTableName(), KEY_COLUMN, CONTEXT_COLUMN, LAST_UPDATED_COLUMN, EXPIRES_AT_COLUMN, VALUE_COLUMN, LAST_UPDATED_COLUMN, EXPIRES_AT_COLUMN, VALUE_COLUMN));
    }

    private PreparedStatement getLastUpdatedStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("SELECT %s, %s FROM %s WHERE %s = ? AND %s = ?", LAST_UPDATED_COLUMN, EXPIRES_AT_COLUMN, this.getTableName(), KEY_COLUMN, CONTEXT_COLUMN));
    }

    private PreparedStatement getEnumerateStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("SELECT %s, %s, %s FROM %s WHERE %s = ?", KEY_COLUMN, VALUE_COLUMN, EXPIRES_AT_COLUMN, this.getTableName(), CONTEXT_COLUMN));
    }

    private PreparedStatement getDeleteStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("DELETE FROM %s WHERE %s = ? AND %s = ?", this.getTableName(), KEY_COLUMN, CONTEXT_COLUMN));
    }

    private PreparedStatement getTruncateStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("DELETE FROM %s WHERE %s = ?", this.getTableName(), CONTEXT_COLUMN));
    }

    public long put(String key, T value, String context, Integer ttlInSeconds) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        long now = System.currentTimeMillis();
        this.withStatement(this::getUpsertStatement, upsertStatement -> {
            upsertStatement.setString(1, key);
            upsertStatement.setString(2, context);
            upsertStatement.setTimestamp(3, new Timestamp(now));
            upsertStatement.setTimestamp(6, new Timestamp(now));
            if (ttlInSeconds != null) {
                long expireTime = now + TimeUnit.MILLISECONDS.convert(ttlInSeconds.intValue(), TimeUnit.SECONDS);
                upsertStatement.setTimestamp(4, new Timestamp(expireTime));
                upsertStatement.setTimestamp(7, new Timestamp(expireTime));
            } else {
                upsertStatement.setNull(4, 91);
                upsertStatement.setNull(7, 91);
            }
            upsertStatement.setObject(5, this.getSQLTypeFromValueType(value));
            upsertStatement.setObject(8, this.getSQLTypeFromValueType(value));
            return upsertStatement.execute();
        });
        return now;
    }

    public Optional<T> get(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return this.withStatement(this::getSelectStatement, selectStatement -> {
            selectStatement.setString(1, key);
            selectStatement.setString(2, context);
            try (ResultSet resultSet = selectStatement.executeQuery();){
                if (!resultSet.next()) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                if (AbstractPostgresKeyValueStore.isExpired(resultSet)) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                Optional<T> optional = Optional.of(this.getValueTypeFromSQLType(resultSet, VALUE_COLUMN));
                return optional;
            }
        });
    }

    public Optional<Optional<T>> getIfStale(String key, String context, long timestamp) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        OptionalLong lastUpdated = this.getLastUpdated(key, context);
        if (!lastUpdated.isPresent()) {
            return Optional.empty();
        }
        if (timestamp >= lastUpdated.getAsLong()) {
            return Optional.of(Optional.empty());
        }
        Optional<T> value = this.get(key, context);
        if (!value.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public OptionalLong getLastUpdated(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return this.withStatement(this::getLastUpdatedStatement, lastUpdatedStatement -> {
            lastUpdatedStatement.setString(1, key);
            lastUpdatedStatement.setString(2, context);
            try (ResultSet resultSet = lastUpdatedStatement.executeQuery();){
                if (!resultSet.next()) {
                    OptionalLong optionalLong = OptionalLong.empty();
                    return optionalLong;
                }
                if (AbstractPostgresKeyValueStore.isExpired(resultSet)) {
                    OptionalLong optionalLong = OptionalLong.empty();
                    return optionalLong;
                }
                OptionalLong optionalLong = OptionalLong.of(resultSet.getTimestamp(LAST_UPDATED_COLUMN).getTime());
                return optionalLong;
            }
        });
    }

    public Map<String, T> enumerateContext(String context) {
        Objects.requireNonNull(context);
        return this.withStatement(this::getEnumerateStatement, enumerateStatement -> {
            HashMap<String, T> resultMap = new HashMap<String, T>();
            enumerateStatement.setString(1, context);
            try (ResultSet enumerateResult = enumerateStatement.executeQuery();){
                while (enumerateResult.next()) {
                    if (AbstractPostgresKeyValueStore.isExpired(enumerateResult)) continue;
                    resultMap.put(enumerateResult.getString(KEY_COLUMN), this.getValueTypeFromSQLType(enumerateResult, VALUE_COLUMN));
                }
            }
            return resultMap;
        });
    }

    public void delete(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        this.withStatement(this::getDeleteStatement, deleteStatement -> {
            deleteStatement.setString(1, key);
            deleteStatement.setString(2, context);
            return deleteStatement.execute();
        });
    }

    public void truncateContext(String context) {
        Objects.requireNonNull(context);
        this.withStatement(this::getTruncateStatement, truncateStatement -> {
            truncateStatement.setString(1, context);
            return truncateStatement.execute();
        });
    }

    protected S getSQLTypeFromValueType(T value) {
        return (S)value;
    }

    protected abstract T getValueTypeFromSQLType(ResultSet var1, String var2) throws SQLException;

    protected String getValueStatementPlaceholder() {
        return "?";
    }

    protected abstract String getTableName();

    protected abstract String getPkConstraintName();

    public String getName() {
        return "Postgres";
    }

    /*
     * Exception decompiling
     */
    private <U> U withStatement(ConnectionToStatement connectionToStatement, StatementToResult<U> statementToResult) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    private static interface ConnectionToStatement {
        public PreparedStatement getStatement(Connection var1) throws SQLException;
    }

    @FunctionalInterface
    private static interface StatementToResult<T> {
        public T getResult(PreparedStatement var1) throws SQLException;
    }
}

