/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.json.shell;

import java.util.Objects;
import java.util.Optional;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.distributed.kvstore.api.JsonStore;

@Command(scope="opennms-kv-json", name="get", description="Get a record from the JSON store")
@Service
public class JsonStoreGet
implements Action {
    @Reference
    private JsonStore jsonStore;
    @Argument(index=0, description="The key to look up", required=true)
    private String key;
    @Argument(index=1, description="The key's context", required=true)
    private String context;

    public Object execute() {
        Objects.requireNonNull(this.key);
        Objects.requireNonNull(this.context);
        Optional value = this.jsonStore.get(this.key, this.context);
        if (value.isPresent()) {
            System.out.println((String)value.get());
        } else {
            System.out.println(String.format("Value for key '%s' could not be found", this.key));
        }
        return null;
    }
}

