/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.blob.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.opennms.features.distributed.cassandra.api.CassandraSchemaManagerFactory;
import org.opennms.features.distributed.cassandra.api.CassandraSession;
import org.opennms.features.distributed.cassandra.api.CassandraSessionFactory;
import org.opennms.features.distributed.kvstore.api.AbstractKeyValueStore;
import org.opennms.features.distributed.kvstore.api.BlobStore;

public class CassandraBlobStore
extends AbstractKeyValueStore<byte[]>
implements BlobStore {
    private static final String KEY_COLUMN = "key";
    private static final String CONTEXT_COLUMN = "context";
    private static final String VALUE_COLUMN = "value";
    private static final String TIMESTAMP_COLUMN = "lastUpdated";
    private static final String TABLE_NAME = "kvstore_blob";
    private final CassandraSession session;
    private final PreparedStatement insertStmt;
    private final PreparedStatement insertWithTtlStmt;
    private final PreparedStatement selectStmt;
    private final PreparedStatement timestampStmt;

    public CassandraBlobStore(CassandraSessionFactory sessionFactory, CassandraSchemaManagerFactory cassandraSchemaManagerFactory) throws IOException {
        Objects.requireNonNull(sessionFactory);
        Objects.requireNonNull(cassandraSchemaManagerFactory);
        cassandraSchemaManagerFactory.getSchemaManager().create(() -> ((Object)((Object)this)).getClass().getResourceAsStream("/cql/kv.cql"));
        this.session = sessionFactory.getSession();
        this.insertStmt = this.session.prepare(String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?)", TABLE_NAME, KEY_COLUMN, CONTEXT_COLUMN, VALUE_COLUMN, TIMESTAMP_COLUMN));
        this.insertWithTtlStmt = this.session.prepare(String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?) USING TTL ?", TABLE_NAME, KEY_COLUMN, CONTEXT_COLUMN, VALUE_COLUMN, TIMESTAMP_COLUMN));
        this.selectStmt = this.session.prepare(String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ?", VALUE_COLUMN, TABLE_NAME, KEY_COLUMN, CONTEXT_COLUMN));
        this.timestampStmt = this.session.prepare(String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ?", TIMESTAMP_COLUMN, TABLE_NAME, KEY_COLUMN, CONTEXT_COLUMN));
    }

    public long put(String key, byte[] value, String context, Integer ttlInSeconds) {
        long timestamp = System.currentTimeMillis();
        Statement statement = this.getStatementForInsert(key, context, ByteBuffer.wrap(value), timestamp, ttlInSeconds);
        this.session.execute(statement);
        return timestamp;
    }

    public Optional<byte[]> get(String key, String context) {
        ResultSet resultSet = this.session.execute((Statement)this.selectStmt.bind(new Object[]{key, context}));
        Row row = resultSet.one();
        if (row == null) {
            return Optional.empty();
        }
        byte[] serializedValue = row.getBytes(VALUE_COLUMN).array();
        return Optional.of(serializedValue);
    }

    public CompletableFuture<Long> putAsync(String key, byte[] value, String context, Integer ttlInSeconds) {
        CompletableFuture<Long> putFuture = new CompletableFuture<Long>();
        long timestamp = System.currentTimeMillis();
        try {
            Statement statement = this.getStatementForInsert(key, context, ByteBuffer.wrap(value), timestamp, ttlInSeconds);
            ResultSetFuture resultSetFuture = this.session.executeAsync(statement);
            resultSetFuture.addListener(() -> {
                try {
                    resultSetFuture.getUninterruptibly();
                    putFuture.complete(timestamp);
                }
                catch (Exception e) {
                    putFuture.completeExceptionally(e);
                }
            }, MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            putFuture.completeExceptionally(e);
        }
        return putFuture;
    }

    public CompletableFuture<Optional<byte[]>> getAsync(String key, String context) {
        CompletableFuture<Optional<byte[]>> getFuture = new CompletableFuture<Optional<byte[]>>();
        try {
            ResultSetFuture resultSetFuture = this.session.executeAsync((Statement)this.selectStmt.bind(new Object[]{key, context}));
            resultSetFuture.addListener(() -> CassandraBlobStore.processGetFutureResult(getFuture, resultSetFuture), MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            getFuture.completeExceptionally(e);
        }
        return getFuture;
    }

    public Optional<Optional<byte[]>> getIfStale(String key, String context, long timestamp) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        OptionalLong lastUpdated = this.getLastUpdated(key, context);
        if (!lastUpdated.isPresent()) {
            return Optional.empty();
        }
        if (timestamp >= lastUpdated.getAsLong()) {
            return Optional.of(Optional.empty());
        }
        Optional<byte[]> value = this.get(key, context);
        if (!value.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public OptionalLong getLastUpdated(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        ResultSet resultSet = this.session.execute((Statement)this.timestampStmt.bind(new Object[]{key, context}));
        Row row = resultSet.one();
        if (row == null) {
            return OptionalLong.empty();
        }
        Date lastUpdated = row.getTimestamp(TIMESTAMP_COLUMN);
        return OptionalLong.of(lastUpdated.getTime());
    }

    public CompletableFuture<Optional<Optional<byte[]>>> getIfStaleAsync(String key, String context, long timestamp) {
        CompletableFuture<Optional<Optional<byte[]>>> getIfStaleFuture = new CompletableFuture<Optional<Optional<byte[]>>>();
        this.getLastUpdatedAsync(key, context).whenComplete((lastUpdated, t) -> {
            if (t != null) {
                getIfStaleFuture.completeExceptionally((Throwable)t);
                return;
            }
            if (!lastUpdated.isPresent()) {
                getIfStaleFuture.complete(Optional.empty());
                return;
            }
            if (timestamp >= lastUpdated.getAsLong()) {
                getIfStaleFuture.complete(Optional.of(Optional.empty()));
                return;
            }
            this.getAsync(key, context).whenComplete((val, th) -> {
                if (th != null) {
                    getIfStaleFuture.completeExceptionally((Throwable)th);
                    return;
                }
                if (!val.isPresent()) {
                    getIfStaleFuture.complete(Optional.empty());
                }
                getIfStaleFuture.complete(Optional.of(val));
            });
        });
        return getIfStaleFuture;
    }

    public CompletableFuture<OptionalLong> getLastUpdatedAsync(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        CompletableFuture<OptionalLong> tsFuture = new CompletableFuture<OptionalLong>();
        try {
            ResultSetFuture resultSetFuture = this.session.executeAsync((Statement)this.timestampStmt.bind(new Object[]{key, context}));
            resultSetFuture.addListener(() -> CassandraBlobStore.processLastUpdatedFutureResult(tsFuture, resultSetFuture), MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            tsFuture.completeExceptionally(e);
        }
        return tsFuture;
    }

    private Statement getStatementForInsert(String key, String context, ByteBuffer serializedValue, long timestamp, Integer ttlInSeconds) {
        BoundStatement statement;
        if (ttlInSeconds != null) {
            if (ttlInSeconds <= 0) {
                throw new IllegalArgumentException("TTL must be positive and greater than 0");
            }
            statement = this.insertWithTtlStmt.bind(new Object[]{key, context, serializedValue, new Date(timestamp), ttlInSeconds});
        } else {
            statement = this.insertStmt.bind(new Object[]{key, context, serializedValue, new Date(timestamp)});
        }
        return statement;
    }

    private static void processGetFutureResult(CompletableFuture<Optional<byte[]>> future, ResultSetFuture resultSetFuture) {
        ResultSet resultSet;
        try {
            resultSet = resultSetFuture.getUninterruptibly();
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            return;
        }
        Row row = resultSet.one();
        if (row == null) {
            future.complete(Optional.empty());
            return;
        }
        future.complete(Optional.of(row.getBytes(VALUE_COLUMN).array()));
    }

    private static void processLastUpdatedFutureResult(CompletableFuture<OptionalLong> future, ResultSetFuture resultSetFuture) {
        ResultSet resultSet;
        try {
            resultSet = resultSetFuture.getUninterruptibly();
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            return;
        }
        Row row = resultSet.one();
        if (row == null) {
            future.complete(OptionalLong.empty());
            return;
        }
        Date lastUpdated = row.getTimestamp(TIMESTAMP_COLUMN);
        future.complete(OptionalLong.of(lastUpdated.getTime()));
    }

    public String getName() {
        return "Cassandra";
    }
}

