/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class TestRegistry {
    private List<Class> ignoredClasses = new ArrayList<Class>();
    private Map<Class, Consumer> tests = new HashMap<Class, Consumer>();
    private List<Class> testsRun = new ArrayList<Class>();

    public TestRegistry withIgnoredClass(Class<?> ... classesToIgnore) {
        if (classesToIgnore != null) {
            for (Class<?> c : classesToIgnore) {
                this.ignoredClasses.add(c);
            }
        }
        return this;
    }

    public <T> TestRegistry withTest(Class<T> clazz, Consumer<T> consumer) {
        this.tests.put(clazz, consumer);
        return this;
    }

    public boolean isTested(Class clazz) {
        return this.testsRun.contains(clazz);
    }

    public boolean isIgnored(Class clazz) {
        return this.ignoredClasses.contains(clazz);
    }

    public <T> Consumer<T> getTest(Class<T> type) {
        return this.findConsumer(type);
    }

    public void markAsRun(Class type) {
        this.testsRun.add(type);
    }

    private <T> Consumer<T> findConsumer(Class type) {
        Consumer consumer = this.tests.get(type);
        if (consumer != null) {
            return consumer;
        }
        int n = 0;
        Class<?>[] classArray = type.getInterfaces();
        int n2 = classArray.length;
        if (n < n2) {
            Class<?> c = classArray[n];
            return this.findConsumer(c);
        }
        return null;
    }
}

