/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.opennms.netmgt.model.FilterManager;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class HibernateFilterManager
implements FilterManager {
    private HibernateTemplate m_template;
    private String[] m_authorizationGroups;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.m_template = new HibernateTemplate(sessionFactory);
    }

    public void disableAuthorizationFilter() {
        this.m_authorizationGroups = null;
        HibernateCallback<Object> cb = new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.disableFilter("authorizedOnly");
                return null;
            }
        };
        this.m_template.execute((HibernateCallback)cb);
    }

    public String[] getAuthorizationGroups() {
        return this.m_authorizationGroups;
    }

    public boolean isEnabled() {
        return this.m_authorizationGroups != null;
    }

    public void enableAuthorizationFilter(String[] authorizationGroups) {
        this.m_authorizationGroups = Arrays.copyOf(authorizationGroups, authorizationGroups.length);
        HibernateCallback<Object> cb = new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.enableFilter("authorizedOnly").setParameterList("userGroups", (Object[])HibernateFilterManager.this.m_authorizationGroups);
                return null;
            }
        };
        this.m_template.execute((HibernateCallback)cb);
    }
}

