/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.LocationMonitorIpInterface;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;

public class LocationMonitorDaoHibernate
extends AbstractDaoHibernate<OnmsLocationMonitor, String>
implements LocationMonitorDao {
    private static final Logger LOG = LoggerFactory.getLogger(LocationMonitorDaoHibernate.class);

    public LocationMonitorDaoHibernate() {
        super(OnmsLocationMonitor.class);
    }

    @Override
    protected void initDao() throws Exception {
        super.initDao();
    }

    @Override
    public OnmsLocationSpecificStatus getMostRecentStatusChange(final OnmsLocationMonitor locationMonitor, final OnmsMonitoredService monSvc) {
        HibernateCallback<OnmsLocationSpecificStatus> callback = new HibernateCallback<OnmsLocationSpecificStatus>(){

            public OnmsLocationSpecificStatus doInHibernate(Session session) throws HibernateException, SQLException {
                return (OnmsLocationSpecificStatus)session.createQuery("from OnmsLocationSpecificStatus status where status.locationMonitor = :locationMonitor and status.monitoredService = :monitoredService order by status.pollResult.timestamp desc").setEntity("locationMonitor", (Object)locationMonitor).setEntity("monitoredService", (Object)monSvc).setMaxResults(1).uniqueResult();
            }
        };
        return (OnmsLocationSpecificStatus)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    @Override
    public void saveStatusChange(OnmsLocationSpecificStatus statusChange) {
        this.getHibernateTemplate().save((Object)statusChange);
    }

    @Override
    public Collection<OnmsLocationMonitor> findByApplication(OnmsApplication application) {
        return this.findObjects(OnmsLocationMonitor.class, "select distinct l from OnmsLocationSpecificStatus as status join status.monitoredService as m join m.applications a join status.locationMonitor as l where a = ? and status.id in ( select max(s.id) from OnmsLocationSpecificStatus as s group by s.locationMonitor, s.monitoredService )", application);
    }

    @Override
    public Collection<OnmsLocationMonitor> findByLocationDefinition(OnmsMonitoringLocation locationDefinition) {
        if (locationDefinition == null) {
            throw new IllegalArgumentException("Location definition is null");
        }
        return this.find("from OnmsLocationMonitor as mon where mon.location = ?", locationDefinition.getLocationName());
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getAllMostRecentStatusChanges() {
        return this.getAllStatusChangesAt(new Date());
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getAllStatusChangesAt(Date timestamp) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status left join fetch status.locationMonitor as l left join fetch status.monitoredService as m left join fetch m.serviceType left join fetch m.ipInterface where status.id in (select max(s.id) from OnmsLocationSpecificStatus as s where s.pollResult.timestamp <? group by s.locationMonitor, s.monitoredService )", timestamp);
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesBetween(Date startDate, Date endDate) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where ? <= status.pollResult.timestamp and status.pollResult.timestamp < ?", startDate, endDate);
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesForLocationBetween(Date startDate, Date endDate, String locationName) {
        Collection<OnmsLocationSpecificStatus> statuses = this.getMostRecentStatusChangesForDateAndLocation(startDate, locationName);
        statuses.addAll(this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where ? <= status.pollResult.timestamp and status.pollResult.timestamp < ? and status.locationMonitor.location = ?", startDate, endDate, locationName));
        return statuses;
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesForApplicationBetween(Date startDate, Date endDate, String applicationName) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status left join fetch status.monitoredService as m left join fetch m.applications as a left join fetch status.locationMonitor as lm where a.name = ? and ( status.pollResult.timestamp between ? and ?  or  status.id in    (       select max(s.id) from OnmsLocationSpecificStatus as s        where s.pollResult.timestamp < ?        group by s.locationMonitor, s.monitoredService    ))", applicationName, startDate, endDate, startDate);
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesBetweenForApplications(final Date startDate, final Date endDate, final Collection<String> applicationNames) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<OnmsLocationSpecificStatus>>(){

            public List<OnmsLocationSpecificStatus> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("select distinct status from OnmsLocationSpecificStatus as status left join fetch status.monitoredService as m left join fetch m.serviceType left join fetch m.applications as a left join fetch status.locationMonitor as lm where a.name in (:applicationNames) and ( status.pollResult.timestamp between :startDate and :endDate  or  status.id in    (       select max(s.id) from OnmsLocationSpecificStatus as s        where s.pollResult.timestamp < :startDate        group by s.locationMonitor, s.monitoredService    )) order by status.pollResult.timestamp").setParameterList("applicationNames", applicationNames).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).list();
            }
        });
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getMostRecentStatusChangesForLocation(String locationName) {
        return this.getMostRecentStatusChangesForDateAndLocation(new Date(), locationName);
    }

    private Collection<OnmsLocationSpecificStatus> getMostRecentStatusChangesForDateAndLocation(Date date, String locationName) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status left join fetch status.locationMonitor as l left join fetch status.monitoredService as m left join fetch m.serviceType left join fetch m.ipInterface where status.pollResult.timestamp = (     select max(recentStatus.pollResult.timestamp)     from OnmsLocationSpecificStatus as recentStatus     where recentStatus.pollResult.timestamp < ?     group by recentStatus.locationMonitor, recentStatus.monitoredService     having recentStatus.locationMonitor = status.locationMonitor     and recentStatus.monitoredService = status.monitoredService ) and l.location = ?", date, locationName);
    }

    @Override
    public Collection<LocationMonitorIpInterface> findStatusChangesForNodeForUniqueMonitorAndInterface(int nodeId) {
        List l = this.getHibernateTemplate().find("select distinct status.locationMonitor, status.monitoredService.ipInterface from OnmsLocationSpecificStatus as status where status.monitoredService.ipInterface.node.id = ?", (Object)nodeId);
        HashSet<LocationMonitorIpInterface> ret = new HashSet<LocationMonitorIpInterface>();
        for (Object[] tuple : l) {
            OnmsLocationMonitor mon = (OnmsLocationMonitor)tuple[0];
            OnmsIpInterface ip = (OnmsIpInterface)tuple[1];
            ret.add(new LocationMonitorIpInterface(mon, ip));
        }
        return ret;
    }

    @Override
    public void pauseAll() {
        this.getHibernateTemplate().bulkUpdate("update OnmsLocationMonitor as mon set mon.status = ? where mon.status != ?", new Object[]{OnmsLocationMonitor.MonitorStatus.PAUSED, OnmsLocationMonitor.MonitorStatus.STOPPED});
    }

    @Override
    public void resumeAll() {
        this.getHibernateTemplate().bulkUpdate("update OnmsLocationMonitor as mon set mon.status = ? where mon.status = ?", new Object[]{OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.PAUSED});
    }
}

