/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.collections.LazySet;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.LazyResourceAttributeLoader;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.model.LocationMonitorIpInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.springframework.orm.ObjectRetrievalFailureException;

public class DistributedStatusResourceType
implements OnmsResourceType {
    public static final String DISTRIBUTED_DIRECTORY = "distributed";
    public static final String TYPE_NAME = "distributedStatus";
    private final ResourceStorageDao m_resourceStorageDao;
    private final LocationMonitorDao m_locationMonitorDao;

    public DistributedStatusResourceType(ResourceStorageDao resourceStorageDao, LocationMonitorDao locationMonitorDao) {
        this.m_resourceStorageDao = resourceStorageDao;
        this.m_locationMonitorDao = locationMonitorDao;
    }

    public String getLabel() {
        return "Distributed Status";
    }

    public String getName() {
        return TYPE_NAME;
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    public boolean isResourceTypeOnParent(OnmsResource parent) {
        return this.getResourcesForParent(parent).size() > 0;
    }

    public List<OnmsResource> getResourcesForParent(OnmsResource parent) {
        if (!NodeResourceType.isNode(parent)) {
            return Collections.emptyList();
        }
        OnmsNode node = ResourceTypeUtils.getNodeFromResource((OnmsResource)parent);
        LinkedList resources = Lists.newLinkedList();
        Collection<LocationMonitorIpInterface> statuses = this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(node.getId());
        for (LocationMonitorIpInterface status : statuses) {
            OnmsIpInterface ipInterface;
            String ipAddr;
            String definitionName = status.getLocationMonitor().getLocation();
            String id = status.getLocationMonitor().getId();
            if (!this.m_resourceStorageDao.exists(DistributedStatusResourceType.getRelativeInterfacePath(id, ipAddr = InetAddressUtils.str((InetAddress)(ipInterface = status.getIpInterface()).getIpAddress())), 0)) continue;
            resources.add(this.createResource(definitionName, id, ipAddr));
        }
        return OnmsResource.sortIntoResourceList((List)resources);
    }

    public OnmsResource getChildByName(OnmsResource parent, String name) {
        for (OnmsResource resource : this.getResourcesForParent(parent)) {
            if (!resource.getName().equals(name)) continue;
            resource.setParent(parent);
            return resource;
        }
        throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)("No child with name '" + name + "' found on '" + parent + "'"));
    }

    private OnmsResource createResource(String definitionName, String locationMonitorId, String ipAddress) {
        String monitor = definitionName + "-" + locationMonitorId;
        String label = ipAddress + " from " + monitor;
        ResourcePath path = DistributedStatusResourceType.getRelativeInterfacePath(locationMonitorId, ipAddress);
        LazyResourceAttributeLoader loader = new LazyResourceAttributeLoader(this.m_resourceStorageDao, path);
        LazySet set = new LazySet((LazySet.Loader)loader);
        return new OnmsResource(DistributedStatusResourceType.getResourceName(locationMonitorId, ipAddress), label, (OnmsResourceType)this, (Set)set, path);
    }

    protected static String getResourceName(String locationMonitorId, String ipAddress) {
        return String.format("%s%s%s", locationMonitorId, File.separator, ipAddress);
    }

    private static ResourcePath getRelativeInterfacePath(String id, String ipAddr) {
        return new ResourcePath(new String[]{"response", DISTRIBUTED_DIRECTORY, id, ipAddr});
    }
}

