/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.bsm.persistence.api.EdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.EdgeEntityVisitor;
import org.opennms.netmgt.bsm.persistence.api.functions.map.AbstractMapFunctionEntity;

@Entity
@Table(name="bsm_service_edge")
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="")
public class BusinessServiceEdgeEntity
implements EdgeEntity {
    public static final int DEFAULT_WEIGHT = 1;
    private Long m_id;
    private BusinessServiceEntity m_businessService;
    private boolean m_enabled = true;
    private int m_weight = 1;
    private AbstractMapFunctionEntity m_mapFunction;

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    @Column(name="id", nullable=false)
    public Long getId() {
        return this.m_id;
    }

    public void setId(Long id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="bsm_service_id")
    public BusinessServiceEntity getBusinessService() {
        return this.m_businessService;
    }

    public void setBusinessService(BusinessServiceEntity service) {
        this.m_businessService = Objects.requireNonNull(service);
    }

    @Override
    @Column(name="enabled", nullable=false)
    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    @Override
    @Column(name="weight", nullable=false)
    public int getWeight() {
        return this.m_weight;
    }

    @Override
    @Transient
    public Set<String> getReductionKeys() {
        return Sets.newHashSet();
    }

    public void setWeight(int weight) {
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"weight must be strictly positive.");
        this.m_weight = weight;
    }

    @Override
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="bsm_map_id")
    public AbstractMapFunctionEntity getMapFunction() {
        return this.m_mapFunction;
    }

    public void setMapFunction(AbstractMapFunctionEntity mapFunction) {
        this.m_mapFunction = Objects.requireNonNull(mapFunction);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BusinessServiceEdgeEntity)) {
            return false;
        }
        BusinessServiceEdgeEntity other = (BusinessServiceEdgeEntity)obj;
        if (this.getId() != null) {
            return this.getId().equals(other.getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("id", (Object)this.m_id).add("businessService", this.m_businessService == null ? null : this.m_businessService.getId()).add("enabled", this.m_enabled).add("weight", this.m_weight).add("mapFunction", (Object)this.m_mapFunction).toString();
    }

    public boolean equalsDefinition(BusinessServiceEdgeEntity other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        boolean equals = Objects.equals(this.getWeight(), other.getWeight()) && Objects.equals(this.getBusinessService().getId(), other.getBusinessService().getId()) && this.getMapFunction().equalsDefinition(other.getMapFunction());
        return equals;
    }

    @Override
    public <T> T accept(EdgeEntityVisitor<T> visitor) {
        throw new IllegalStateException("Class '" + this.getClass().getName() + "' did not overwrite accept(EdgeEntityVisitor) method properly");
    }
}

