/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.persistence.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.enlinkd.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.TopologyEntityCache;
import org.opennms.netmgt.enlinkd.persistence.api.TopologyEntityDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyEntityCacheImpl
implements TopologyEntityCache {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyEntityCacheImpl.class);
    private static final String KEY = "KEY";
    private static final String SYSTEM_PROPERTY_CACHE_DURATION = "org.opennms.ui.topology-entity-cache-duration";
    private TopologyEntityDao topologyEntityDao;
    private LoadingCache<String, List<NodeTopologyEntity>> nodeTopologyEntities = this.createCache(new CacheLoader<String, List<NodeTopologyEntity>>(){

        public List<NodeTopologyEntity> load(String key) {
            return TopologyEntityCacheImpl.this.topologyEntityDao.getNodeTopologyEntities();
        }
    });
    private LoadingCache<String, List<CdpLinkTopologyEntity>> cdpLinkTopologyEntities = this.createCache(new CacheLoader<String, List<CdpLinkTopologyEntity>>(){

        public List<CdpLinkTopologyEntity> load(String key) {
            return TopologyEntityCacheImpl.this.topologyEntityDao.getCdpLinkTopologyEntities();
        }
    });

    private <Key, Value> LoadingCache<Key, Value> createCache(CacheLoader<Key, Value> loader) {
        return CacheBuilder.newBuilder().expireAfterWrite((long)this.getCacheDuration(), TimeUnit.SECONDS).build(loader);
    }

    @Override
    public List<NodeTopologyEntity> getNodeTopolgyEntities() {
        return (List)this.nodeTopologyEntities.getUnchecked((Object)KEY);
    }

    @Override
    public List<CdpLinkTopologyEntity> getCdpLinkTopologyEntities() {
        return (List)this.cdpLinkTopologyEntities.getUnchecked((Object)KEY);
    }

    @Override
    public void refresh() {
        this.nodeTopologyEntities.refresh((Object)KEY);
        this.cdpLinkTopologyEntities.refresh((Object)KEY);
    }

    private int getCacheDuration() {
        return Integer.getInteger(SYSTEM_PROPERTY_CACHE_DURATION, 300);
    }

    public void setTopologyEntityDao(TopologyEntityDao topologyEntityDao) {
        this.topologyEntityDao = topologyEntityDao;
    }
}

