/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.persistence.api;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEdgeEntity;
import org.opennms.netmgt.bsm.persistence.api.BusinessServiceEntity;
import org.opennms.netmgt.bsm.persistence.api.EdgeEntityVisitor;

@Entity
@Table(name="bsm_service_children")
@PrimaryKeyJoinColumn(name="id")
@DiscriminatorValue(value="children")
public class BusinessServiceChildEdgeEntity
extends BusinessServiceEdgeEntity {
    private BusinessServiceEntity child;

    public void setChild(BusinessServiceEntity child) {
        this.child = child;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="bsm_service_child_id", nullable=false)
    public BusinessServiceEntity getChild() {
        return this.child;
    }

    @Override
    @Transient
    public Set<String> getReductionKeys() {
        return Sets.newHashSet();
    }

    @Override
    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("child", this.child == null ? null : this.child.getId()).toString();
    }

    @Override
    public boolean equalsDefinition(BusinessServiceEdgeEntity other) {
        boolean equalsSuper = super.equalsDefinition(other);
        if (equalsSuper) {
            return Objects.equals(this.child.getId(), ((BusinessServiceChildEdgeEntity)other).getChild().getId());
        }
        return false;
    }

    @Override
    public <T> T accept(EdgeEntityVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

