/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.coordination.shell;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.distributed.coordination.api.DomainManager;
import org.opennms.features.distributed.coordination.api.DomainManagerFactory;
import org.opennms.features.distributed.coordination.api.Role;
import org.opennms.features.distributed.coordination.api.RoleChangeHandler;

@Command(scope="opnennms-coordination", name="join-election-domain", description="Joins the specified election domain")
@Service
public class JoinElectionDomain
implements Action,
RoleChangeHandler {
    @Argument(index=0, name="domain", description="The domain to join", required=true, multiValued=false)
    private String domain;
    @Reference
    private DomainManagerFactory domainManagerFactory;
    private static final String testId = "test.id";

    public Object execute() {
        DomainManager manager = this.domainManagerFactory.getManagerForDomain(this.domain);
        manager.register(testId, (RoleChangeHandler)this);
        try {
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted");
            System.out.println("Leaving domain " + this.domain);
            manager.deregister(testId);
            return null;
        }
    }

    public void handleRoleChange(Role role, String domain) {
        System.out.println(role + " for domain " + domain);
    }
}

