/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.coordination.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opennms.features.distributed.coordination.common.AbstractDomainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionBasedDomainManager
extends AbstractDomainManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionBasedDomainManager.class);
    private boolean connected = false;
    private final ExecutorService connectionPool = Executors.newSingleThreadExecutor();

    protected ConnectionBasedDomainManager(String domain) {
        super(domain);
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void handleConnectResult(Void result, Throwable exception) {
        boolean bl = this.connected = exception == null;
        if (!this.isConnected()) {
            this.failedToConnect(exception);
        }
    }

    private void handleDisconnectResult(Void result, Throwable exception) {
        this.connected = false;
    }

    protected void failedToConnect(Throwable exception) {
        LOG.warn("Failed to connect due to exception", exception);
    }

    protected abstract void connect();

    protected abstract void disconnect();

    @Override
    protected final void onFirstRegister() {
        CompletableFuture.runAsync(this::connect, this.connectionPool).whenComplete(this::handleConnectResult);
    }

    @Override
    protected final void onLastDeregister() {
        CompletableFuture.runAsync(this::disconnect, this.connectionPool).whenComplete(this::handleDisconnectResult);
    }

    @Override
    public String toString() {
        return "org.opennms.features.distributed.coordination.base.ConnectionBasedDomainManager{connected=" + this.connected + "} " + super.toString();
    }
}

