/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.web.internal;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.opennms.features.datachoices.internal.StateManager;
import org.opennms.features.datachoices.internal.UsageStatisticsReportDTO;
import org.opennms.features.datachoices.internal.UsageStatisticsReporter;
import org.opennms.features.datachoices.web.DataChoiceRestService;

public class DataChoiceRestServiceImpl
implements DataChoiceRestService {
    private StateManager m_stateManager;
    private UsageStatisticsReporter m_usageStatisticsReporter;

    @Override
    public void updateCollectUsageStatisticFlag(HttpServletRequest request, String action) {
        if (action == null) {
            return;
        }
        try {
            switch (action) {
                case "enable": {
                    this.m_stateManager.setEnabled(true, request.getRemoteUser());
                    break;
                }
                case "disable": {
                    this.m_stateManager.setEnabled(false, request.getRemoteUser());
                    break;
                }
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public UsageStatisticsReportDTO getUsageStatistics() throws ServletException, IOException {
        return this.m_usageStatisticsReporter.generateReport();
    }

    public void setStateManager(StateManager stateManager) {
        this.m_stateManager = stateManager;
    }

    public void setUsageStatisticsReporter(UsageStatisticsReporter usageStatisticsReporter) {
        this.m_usageStatisticsReporter = Objects.requireNonNull(usageStatisticsReporter);
    }
}

