/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.opennms.core.utils.PropertiesCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateManager {
    private static final Logger LOG = LoggerFactory.getLogger(StateManager.class);
    private static final String PROPERTIES_FILE_NAME = "org.opennms.features.datachoices.cfg";
    private static final String ENABLED_KEY = "enabled";
    private static final String SYSTEM_ID_KEY = "systemid";
    private static final String ACKNOWLEDGED_BY_KEY = "acknowledged-by";
    private static final String ACKNOWLEDGED_AT_KEY = "acknowledged-at";
    private final List<StateChangeHandler> m_listeners = Lists.newArrayList();
    private final PropertiesCache m_propertiesCache = new PropertiesCache();
    private final File m_propertiesFile;

    public StateManager() {
        String opennmsHomeStr = System.getProperty("opennms.home");
        if (opennmsHomeStr == null) {
            opennmsHomeStr = "";
        }
        this.m_propertiesFile = Paths.get(opennmsHomeStr, "etc", PROPERTIES_FILE_NAME).toFile();
    }

    public Boolean isEnabled() throws IOException {
        String enabled = this.m_propertiesCache.getProperty(this.m_propertiesFile, ENABLED_KEY);
        return enabled == null ? null : Boolean.valueOf(enabled);
    }

    public void setEnabled(boolean enabled, String user) throws Exception {
        this.m_propertiesCache.setProperty(this.m_propertiesFile, ENABLED_KEY, Boolean.valueOf(enabled).toString());
        this.m_propertiesCache.setProperty(this.m_propertiesFile, ACKNOWLEDGED_BY_KEY, user == null ? "" : user);
        this.m_propertiesCache.setProperty(this.m_propertiesFile, ACKNOWLEDGED_AT_KEY, new Date().toString());
        for (StateChangeHandler listener : this.m_listeners) {
            listener.onIsEnabledChanged(enabled);
        }
    }

    public String getOrGenerateSystemId() throws IOException {
        String systemId = this.m_propertiesCache.getProperty(this.m_propertiesFile, SYSTEM_ID_KEY);
        if (systemId == null) {
            LOG.debug("No existing system id was found. Generating a new system id.");
            systemId = UUID.randomUUID().toString();
            this.m_propertiesCache.setProperty(this.m_propertiesFile, SYSTEM_ID_KEY, systemId);
        }
        return systemId;
    }

    public String getAndRegenerateSystemId() throws IOException {
        String systemId = UUID.randomUUID().toString();
        this.m_propertiesCache.setProperty(this.m_propertiesFile, SYSTEM_ID_KEY, systemId);
        return systemId;
    }

    public void onIsEnabledChanged(StateChangeHandler callback) {
        this.m_listeners.add(Objects.requireNonNull(callback));
    }

    public static interface StateChangeHandler {
        public void onIsEnabledChanged(boolean var1);
    }
}

