/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.web.internal;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.features.datachoices.internal.StateManager;
import org.opennms.features.datachoices.internal.UsageStatisticsReporter;

public class ApiServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private StateManager m_stateManager;
    private UsageStatisticsReporter m_usageStatisticsReporter;

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        String action = request.getParameter("action");
        if (action == null) {
            return;
        }
        try {
            switch (action) {
                case "enable": {
                    this.m_stateManager.setEnabled(true, request.getRemoteUser());
                    break;
                }
                case "disable": {
                    this.m_stateManager.setEnabled(false, request.getRemoteUser());
                    break;
                }
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.getWriter().println(this.m_usageStatisticsReporter.generateReport().toJson(true));
    }

    public void setStateManager(StateManager stateManager) {
        this.m_stateManager = stateManager;
    }

    public void setUsageStatisticsReporter(UsageStatisticsReporter usageStatisticsReporter) {
        this.m_usageStatisticsReporter = Objects.requireNonNull(usageStatisticsReporter);
    }
}

