/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.internal;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.features.datachoices.internal.StateManager;
import org.opennms.features.datachoices.internal.UsageStatisticsReportDTO;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageStatisticsReporter
implements StateManager.StateChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UsageStatisticsReporter.class);
    public static final String USAGE_REPORT = "usage-report";
    private String m_url;
    private long m_interval;
    private Timer m_timer;
    private StateManager m_stateManager;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private MonitoredServiceDao m_monitoredServiceDao;
    private EventDao m_eventDao;
    private AlarmDao m_alarmDao;

    public synchronized void init() {
        if (this.m_timer != null) {
            LOG.warn("Usage statistic reporter was already initialized.");
        }
        try {
            if (Boolean.FALSE.equals(this.m_stateManager.isEnabled())) {
                LOG.info("Usage statistic reporting is disabled.");
                return;
            }
            if (Boolean.TRUE.equals(this.m_stateManager.isEnabled())) {
                this.sendAndSchedule();
            }
            LOG.info("Waiting for user confirmation.");
            this.m_stateManager.onIsEnabledChanged(this);
        }
        catch (IOException e) {
            LOG.warn("Failed check opt-in status. Assuming user opted out.", (Throwable)e);
        }
    }

    public synchronized void sendAndSchedule() {
        LOG.info("Scheduling usage statistics report every {} ms", (Object)this.m_interval);
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new Task(), 0L, this.m_interval);
        this.sendAsync();
    }

    @Override
    public synchronized void onIsEnabledChanged(boolean isEnabled) {
        if (isEnabled && this.m_timer == null) {
            this.sendAndSchedule();
        } else if (!isEnabled && this.m_timer != null) {
            this.destroy();
        }
    }

    public synchronized void destroy() {
        if (this.m_timer != null) {
            LOG.info("Disabling scheduled report.");
            this.m_timer.cancel();
            this.m_timer = null;
        }
    }

    public void sendSync() {
        new Task().run();
    }

    public void sendAsync() {
        Thread thread = new Thread(new Task());
        thread.start();
    }

    public UsageStatisticsReportDTO generateReport() {
        SystemInfoUtils sysInfoUtils = new SystemInfoUtils();
        UsageStatisticsReportDTO usageStatisticsReport = new UsageStatisticsReportDTO();
        try {
            usageStatisticsReport.setSystemId(this.m_stateManager.getOrGenerateSystemId());
        }
        catch (IOException e) {
            LOG.warn("An error occurred while retrieving the system id. The usage report will be submitted with a null system id.", (Throwable)e);
        }
        usageStatisticsReport.setOsName(System.getProperty("os.name"));
        usageStatisticsReport.setOsArch(System.getProperty("os.arch"));
        usageStatisticsReport.setOsVersion(System.getProperty("os.version"));
        usageStatisticsReport.setVersion(sysInfoUtils.getVersion());
        usageStatisticsReport.setPackageName(sysInfoUtils.getPackageName());
        usageStatisticsReport.setNodes(this.m_nodeDao.countAll());
        usageStatisticsReport.setIpInterfaces(this.m_ipInterfaceDao.countAll());
        usageStatisticsReport.setSnmpInterfaces(this.m_snmpInterfaceDao.countAll());
        usageStatisticsReport.setMonitoredServices(this.m_monitoredServiceDao.countAll());
        usageStatisticsReport.setEvents(this.m_eventDao.countAll());
        usageStatisticsReport.setAlarms(this.m_alarmDao.countAll());
        usageStatisticsReport.setNodesBySysOid(this.m_nodeDao.getNumberOfNodesBySysOid());
        return usageStatisticsReport;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public void setInterval(long interval) {
        this.m_interval = interval;
    }

    public void setStateManager(StateManager stateManager) {
        this.m_stateManager = stateManager;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    private class Task
    extends TimerTask {
        private Task() {
        }

        @Override
        public void run() {
            UsageStatisticsReportDTO usageStatsReport = UsageStatisticsReporter.this.generateReport();
            String usageStatsReportJson = usageStatsReport.toJson();
            HttpClientWrapper clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(30000)).setSocketTimeout(Integer.valueOf(30000)).useSystemProxySettings();
            try (CloseableHttpClient client = clientWrapper.getClient();){
                HttpPost httpRequest = new HttpPost(UsageStatisticsReporter.this.m_url + UsageStatisticsReporter.USAGE_REPORT);
                httpRequest.setEntity((HttpEntity)new StringEntity(usageStatsReportJson, ContentType.create((String)"application/json", (String)"UTF-8")));
                LOG.info("Sending usage statistics report to {}: {}", (Object)httpRequest.getURI(), (Object)usageStatsReportJson);
                client.execute((HttpUriRequest)httpRequest);
                LOG.info("Succesfully sent usage statistics report.");
            }
            catch (IOException e) {
                LOG.info("The usage statistics report was not succesfully delivered: {}", (Object)e.getMessage());
            }
        }
    }
}

