/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.shell.internal;

import java.util.Objects;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.features.datachoices.internal.UsageStatisticsReporter;

@Command(scope="datachoices", name="display-usage-report", description="Displays the usage statistics report.")
public class DisplayUsageReportCommand
extends OsgiCommandSupport {
    private UsageStatisticsReporter m_usageStatisticsReporter;

    protected Object doExecute() throws Exception {
        long then = System.currentTimeMillis();
        String reportAsJson = this.m_usageStatisticsReporter.generateReport().toJson(true);
        long delta = System.currentTimeMillis() - then;
        System.out.printf("Generated usage statitics reports in %.2f seconds:\n%s\n", Float.valueOf((float)delta / 1000.0f), reportAsJson);
        return null;
    }

    public void setUsageStatisticsReporter(UsageStatisticsReporter usageStatisticsReporter) {
        this.m_usageStatisticsReporter = Objects.requireNonNull(usageStatisticsReporter);
    }
}

