/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.impl.helper.Coercions;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentException;

public class Annotations {
    private static final Set<Method> ANNOTATION_METHODS = new HashSet<Method>();
    private static final String VALUE_METHOD = "value";
    private static final String PREFIX_CONSTANT = "PREFIX_";
    private static final Pattern p;

    public static boolean isSingleElementAnnotation(Class<?> clazz) {
        boolean result = false;
        if (clazz.isAnnotation()) {
            result = true;
            boolean hasValue = false;
            for (Method method : clazz.getMethods()) {
                boolean isFromAnnotation = false;
                for (Method objMethod : ANNOTATION_METHODS) {
                    if (!objMethod.getName().equals(method.getName()) || !Arrays.equals(objMethod.getParameterTypes(), method.getParameterTypes())) continue;
                    isFromAnnotation = true;
                    break;
                }
                if (isFromAnnotation) continue;
                if (VALUE_METHOD.equals(method.getName())) {
                    hasValue = true;
                    continue;
                }
                if (method.getDefaultValue() != null) continue;
                result = false;
                break;
            }
            if (result) {
                result = hasValue;
            }
        }
        return result;
    }

    public static String getPrefix(Class<?> clazz) {
        try {
            Object value;
            Field f = clazz.getField(PREFIX_CONSTANT);
            if (Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()) && String.class.isAssignableFrom(f.getType()) && (value = f.get(null)) != null) {
                return value.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T> T toObject(Class<T> clazz, Map<String, Object> props, Bundle b, boolean supportsInterfaces) {
        boolean isSingleElementAnn = Annotations.isSingleElementAnnotation(clazz);
        String prefix = Annotations.getPrefix(clazz);
        HashMap<String, Object> m = new HashMap<String, Object>();
        HashMap<String, Method> complexFields = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            Object cooked;
            String name = method.getName();
            String mapped = isSingleElementAnn && name.equals(VALUE_METHOD) ? Annotations.mapTypeNameToKey(clazz.getSimpleName()) : Annotations.mapIdentifierToKey(name);
            String key = prefix == null ? mapped : prefix.concat(mapped);
            Object raw = props.get(key);
            Class<?> returnType = method.getReturnType();
            if (returnType.isInterface() || returnType.isAnnotation()) {
                complexFields.put(key, method);
                continue;
            }
            try {
                if (returnType.isArray()) {
                    Class<?> componentType = returnType.getComponentType();
                    if (componentType.isInterface() || componentType.isAnnotation()) {
                        complexFields.put(key, method);
                        continue;
                    }
                    cooked = Annotations.coerceToArray(componentType, raw, b);
                } else {
                    cooked = Coercions.coerce(returnType, raw, b);
                }
            }
            catch (ComponentException e) {
                cooked = new Invalid(e);
            }
            m.put(name, cooked);
        }
        if (!complexFields.isEmpty()) {
            if (supportsInterfaces) {
                Map<String, List<Map<String, Object>>> nested = Annotations.extractSubMaps(complexFields.keySet(), props);
                for (Map.Entry entry : complexFields.entrySet()) {
                    Method method;
                    Class<?> returnType;
                    List proplist = (List)nested.get(entry.getKey());
                    if (proplist == null) {
                        proplist = Collections.emptyList();
                    }
                    if ((returnType = (method = (Method)entry.getValue()).getReturnType()).isArray()) {
                        Class<?> componentType = returnType.getComponentType();
                        Object result = Array.newInstance(componentType, proplist.size());
                        for (int i = 0; i < proplist.size(); ++i) {
                            Map rawElement = (Map)proplist.get(i);
                            Object cooked = Annotations.toObject(componentType, rawElement, b, supportsInterfaces);
                            Array.set(result, i, cooked);
                        }
                        m.put(method.getName(), result);
                        continue;
                    }
                    if (proplist.isEmpty()) continue;
                    Object cooked = Annotations.toObject(returnType, (Map)proplist.get(0), b, supportsInterfaces);
                    m.put(method.getName(), cooked);
                }
            } else {
                for (Method method : complexFields.values()) {
                    m.put(method.getName(), new Invalid("Invalid annotation member type" + method.getReturnType().getName() + " for member: " + method.getName()));
                }
            }
        }
        Handler h = new Handler(m, clazz);
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)h);
    }

    private static Map<String, List<Map<String, Object>>> extractSubMaps(Collection<String> keys, Map<String, Object> map) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        StringBuilder b = new StringBuilder("(");
        for (String key : keys) {
            b.append(key).append("|");
        }
        b.deleteCharAt(b.length() - 1);
        b.append(")\\.([0-9]*)\\.(.*)");
        Pattern p = Pattern.compile(b.toString());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String longKey = entry.getKey();
            Matcher m = p.matcher(longKey);
            if (!m.matches()) continue;
            String key = m.group(1);
            int index = Integer.parseInt(m.group(2));
            String subkey = m.group(3);
            ArrayList subMapsForKey = (ArrayList)result.get(key);
            if (subMapsForKey == null) {
                subMapsForKey = new ArrayList();
                result.put(key, subMapsForKey);
            }
            for (int i = subMapsForKey.size(); i <= index; ++i) {
                subMapsForKey.add(new HashMap());
            }
            Map subMap = (Map)subMapsForKey.get(index);
            subMap.put(subkey, entry.getValue());
        }
        return result;
    }

    private static Object coerceToArray(Class<?> componentType, Object raw, Bundle bundle) {
        if (raw == null) {
            return Array.newInstance(componentType, 0);
        }
        if (raw.getClass().isArray()) {
            int size = Array.getLength(raw);
            Object result = Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                Object rawElement = Array.get(raw, i);
                Object cooked = Coercions.coerce(componentType, rawElement, bundle);
                Array.set(result, i, cooked);
            }
            return result;
        }
        if (raw instanceof Collection) {
            Collection raws = (Collection)raw;
            int size = raws.size();
            Object result = Array.newInstance(componentType, size);
            int i = 0;
            for (Object rawElement : raws) {
                Object cooked = Coercions.coerce(componentType, rawElement, bundle);
                Array.set(result, i++, cooked);
            }
            return result;
        }
        Object cooked = Coercions.coerce(componentType, raw, bundle);
        Object result = Array.newInstance(componentType, 1);
        Array.set(result, 0, cooked);
        return result;
    }

    static String mapIdentifierToKey(String name) {
        Matcher m = p.matcher(name);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            String replacement = "";
            if (m.group(1) != null) {
                replacement = "-";
            }
            if (m.group(2) != null) {
                replacement = "\\$";
            }
            if (m.group(3) != null) {
                replacement = "";
            }
            if (m.group(4) != null) {
                replacement = "_";
            }
            if (m.group(5) != null) {
                replacement = ".";
            }
            m.appendReplacement(b, replacement);
        }
        m.appendTail(b);
        return b.toString();
    }

    static String mapTypeNameToKey(String name) {
        StringBuilder sb = new StringBuilder();
        boolean lastLow = false;
        for (char c : name.toCharArray()) {
            if (lastLow && (Character.isLetter(c) || Character.isDigit(c)) && Character.isUpperCase(c)) {
                sb.append('.');
            }
            lastLow = false;
            if ((Character.isLetter(c) || Character.isDigit(c)) && Character.isLowerCase(c)) {
                lastLow = true;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    static {
        for (Method m : Annotation.class.getMethods()) {
            ANNOTATION_METHODS.add(m);
        }
        p = Pattern.compile("(\\$_\\$)|(\\$\\$)|(\\$)|(__)|(_)");
    }

    private static final class Invalid {
        private final String message;

        public Invalid(ComponentException e) {
            this.message = e.getMessage();
        }

        public Invalid(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static final class Handler
    implements InvocationHandler {
        private final Map<String, Object> values;
        private final Class<?> type;

        public Handler(Map<String, Object> values, Class<?> type) {
            this.values = values;
            this.type = type;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> value = this.values.get(method.getName());
            if (value instanceof Invalid) {
                throw new ComponentException(((Invalid)((Object)value)).getMessage());
            }
            if (value == null) {
                if (method.getName().equals("hashCode") && method.getParameterTypes().length == 0) {
                    int hashCode = 0;
                    for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                        if (value instanceof Invalid) continue;
                        hashCode += 127 * entry.getKey().hashCode() ^ entry.getValue().hashCode();
                    }
                    value = hashCode;
                } else if (method.getName().equals("equals") && method.getParameterTypes().length == 1) {
                    Object other = args[0];
                    if (proxy == other) {
                        value = true;
                    } else {
                        InvocationHandler ih;
                        value = false;
                        if (this.type.isInstance(other) && Proxy.isProxyClass(other.getClass()) && (ih = Proxy.getInvocationHandler(other)) instanceof Handler) {
                            value = ((Handler)ih).values.equals(this.values);
                        }
                    }
                } else if (method.getName().equals("toString") && method.getParameterTypes().length == 0) {
                    value = this.type.getName() + " : " + this.values;
                } else if (method.getName().equals("annotationType") && method.getParameterTypes().length == 0) {
                    value = this.type;
                }
            }
            return value;
        }
    }
}

