/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.http.protocol;

import java.io.IOException;
import shaded.org.apache.http.HttpException;
import shaded.org.apache.http.HttpResponse;
import shaded.org.apache.http.HttpResponseInterceptor;
import shaded.org.apache.http.annotation.Contract;
import shaded.org.apache.http.annotation.ThreadingBehavior;
import shaded.org.apache.http.protocol.HttpContext;
import shaded.org.apache.http.protocol.HttpDateGenerator;
import shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

