/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserDestinationResult;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultUserDestinationResolver
implements UserDestinationResolver {
    private static final Log logger = LogFactory.getLog(DefaultUserDestinationResolver.class);
    private final UserSessionRegistry userSessionRegistry;
    private String destinationPrefix = "/user/";

    public DefaultUserDestinationResolver(UserSessionRegistry userSessionRegistry) {
        Assert.notNull((Object)userSessionRegistry, (String)"'userSessionRegistry' must not be null");
        this.userSessionRegistry = userSessionRegistry;
    }

    public void setUserDestinationPrefix(String prefix) {
        Assert.hasText((String)prefix, (String)"prefix must not be empty");
        this.destinationPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
    }

    public String getDestinationPrefix() {
        return this.destinationPrefix;
    }

    public UserSessionRegistry getUserSessionRegistry() {
        return this.userSessionRegistry;
    }

    @Override
    public UserDestinationResult resolveDestination(Message<?> message) {
        String destination = SimpMessageHeaderAccessor.getDestination(message.getHeaders());
        DestinationInfo info = this.parseUserDestination(message);
        if (info == null) {
            return null;
        }
        HashSet<String> resolved = new HashSet<String>();
        for (String sessionId : info.getSessionIds()) {
            String targetDestination = this.getTargetDestination(destination, info.getDestinationWithoutPrefix(), sessionId, info.getUser());
            if (targetDestination == null) continue;
            resolved.add(targetDestination);
        }
        return new UserDestinationResult(destination, resolved, info.getSubscribeDestination(), info.getUser());
    }

    private DestinationInfo parseUserDestination(Message<?> message) {
        Set<String> sessionIds;
        String user;
        String subscribeDestination;
        String destinationWithoutPrefix;
        MessageHeaders headers = message.getHeaders();
        SimpMessageType messageType = SimpMessageHeaderAccessor.getMessageType(headers);
        String destination = SimpMessageHeaderAccessor.getDestination(headers);
        Principal principal = SimpMessageHeaderAccessor.getUser(headers);
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        if (destination == null || !this.checkDestination(destination, this.destinationPrefix)) {
            return null;
        }
        if (SimpMessageType.SUBSCRIBE.equals((Object)messageType) || SimpMessageType.UNSUBSCRIBE.equals((Object)messageType)) {
            if (sessionId == null) {
                logger.error((Object)("No session id. Ignoring " + message));
                return null;
            }
            destinationWithoutPrefix = destination.substring(this.destinationPrefix.length() - 1);
            subscribeDestination = destination;
            user = principal != null ? principal.getName() : null;
            sessionIds = Collections.singleton(sessionId);
        } else if (SimpMessageType.MESSAGE.equals((Object)messageType)) {
            int startIndex = this.destinationPrefix.length();
            int endIndex = destination.indexOf(47, startIndex);
            Assert.isTrue((endIndex > 0 ? 1 : 0) != 0, (String)"Expected destination pattern \"/user/{userId}/**\"");
            destinationWithoutPrefix = destination.substring(endIndex);
            subscribeDestination = this.destinationPrefix.substring(0, startIndex - 1) + destinationWithoutPrefix;
            user = destination.substring(startIndex, endIndex);
            user = StringUtils.replace((String)user, (String)"%2F", (String)"/");
            if (user.equals(sessionId)) {
                user = null;
                sessionIds = Collections.singleton(sessionId);
            } else {
                sessionIds = this.userSessionRegistry.getSessionIds(user).contains(sessionId) ? Collections.singleton(sessionId) : this.userSessionRegistry.getSessionIds(user);
            }
        } else {
            return null;
        }
        return new DestinationInfo(destinationWithoutPrefix, subscribeDestination, user, sessionIds);
    }

    protected boolean checkDestination(String destination, String requiredPrefix) {
        return destination.startsWith(requiredPrefix);
    }

    protected String getTargetDestination(String sourceDestination, String sourceDestinationWithoutPrefix, String sessionId, String user) {
        return sourceDestinationWithoutPrefix + "-user" + sessionId;
    }

    public String toString() {
        return "DefaultUserDestinationResolver[prefix=" + this.destinationPrefix + "]";
    }

    private static class DestinationInfo {
        private final String destinationWithoutPrefix;
        private final String subscribeDestination;
        private final String user;
        private final Set<String> sessionIds;

        public DestinationInfo(String destinationWithoutPrefix, String subscribeDestination, String user, Set<String> sessionIds) {
            this.user = user;
            this.destinationWithoutPrefix = destinationWithoutPrefix;
            this.subscribeDestination = subscribeDestination;
            this.sessionIds = sessionIds;
        }

        public String getDestinationWithoutPrefix() {
            return this.destinationWithoutPrefix;
        }

        public String getSubscribeDestination() {
            return this.subscribeDestination;
        }

        public String getUser() {
            return this.user;
        }

        public Set<String> getSessionIds() {
            return this.sessionIds;
        }

        public String toString() {
            return "DestinationInfo[destination=" + this.destinationWithoutPrefix + ", subscribeDestination=" + this.subscribeDestination + ", user=" + this.user + ", sessionIds=" + this.sessionIds + "]";
        }
    }
}

