/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.util.jaas.JaasHelper;

@Command(scope="jaas", name="su", description="Substitute user identity")
@Service
public class SuCommand
implements Action {
    @Option(name="--realm")
    String realm = "karaf";
    @Argument(description="Name of the user to substitute")
    String user = "karaf";
    @Reference
    Session session;

    public Object execute() throws Exception {
        Subject subject = new Subject();
        LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(SuCommand.this.user);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        String password = SuCommand.this.session.readLine("Password: ", Character.valueOf('*'));
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        });
        loginContext.login();
        JaasHelper.doAs(subject, new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws InterruptedException {
                Session newSession = SuCommand.this.session.getFactory().create(System.in, System.out, System.err, SuCommand.this.session.getTerminal(), null, null);
                Object oldIgnoreInterrupts = SuCommand.this.session.get("karaf.ignoreInterrupts");
                try {
                    SuCommand.this.session.put("karaf.ignoreInterrupts", (Object)Boolean.TRUE);
                    String name = "Karaf local console user " + ShellUtil.getCurrentUserName();
                    Thread thread = new Thread((Runnable)newSession, name);
                    thread.start();
                    thread.join();
                }
                finally {
                    SuCommand.this.session.put("karaf.ignoreInterrupts", oldIgnoreInterrupts);
                }
                return null;
            }
        });
        loginContext.logout();
        return null;
    }
}

