/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.ObjectUtils;

public class NativeMessageHeaderAccessor
extends MessageHeaderAccessor {
    public static final String NATIVE_HEADERS = "nativeHeaders";

    protected NativeMessageHeaderAccessor() {
        this((Map<String, List<String>>)null);
    }

    protected NativeMessageHeaderAccessor(Map<String, List<String>> nativeHeaders) {
        if (!CollectionUtils.isEmpty(nativeHeaders)) {
            this.setHeader(NATIVE_HEADERS, new LinkedMultiValueMap(nativeHeaders));
        }
    }

    protected NativeMessageHeaderAccessor(Message<?> message) {
        super(message);
        Map map;
        if (message != null && (map = (Map)this.getHeader(NATIVE_HEADERS)) != null) {
            this.removeHeader(NATIVE_HEADERS);
            this.setHeader(NATIVE_HEADERS, new LinkedMultiValueMap(map));
        }
    }

    private Map<String, List<String>> getNativeHeaders() {
        return (Map)this.getHeader(NATIVE_HEADERS);
    }

    public Map<String, List<String>> toNativeHeaderMap() {
        Map<String, List<String>> map = this.getNativeHeaders();
        return map != null ? new LinkedMultiValueMap(map) : Collections.emptyMap();
    }

    @Override
    public void setImmutable() {
        if (this.isMutable()) {
            Map<String, List<String>> map = this.getNativeHeaders();
            if (map != null) {
                this.removeHeader(NATIVE_HEADERS);
                this.setHeader(NATIVE_HEADERS, Collections.unmodifiableMap(map));
            }
            super.setImmutable();
        }
    }

    public boolean containsNativeHeader(String headerName) {
        Map<String, List<String>> map = this.getNativeHeaders();
        return map != null && map.containsKey(headerName);
    }

    public List<String> getNativeHeader(String headerName) {
        Map<String, List<String>> map = this.getNativeHeaders();
        return map != null ? map.get(headerName) : null;
    }

    public String getFirstNativeHeader(String headerName) {
        List<String> values;
        Map<String, List<String>> map = this.getNativeHeaders();
        if (map != null && (values = map.get(headerName)) != null) {
            return values.get(0);
        }
        return null;
    }

    public void setNativeHeader(String name, String value) {
        Assert.state((boolean)this.isMutable(), (String)"Already immutable");
        LinkedMultiValueMap map = this.getNativeHeaders();
        if (value == null) {
            if (map != null && map.get(name) != null) {
                this.setModified(true);
                map.remove(name);
            }
            return;
        }
        if (map == null) {
            map = new LinkedMultiValueMap(4);
            this.setHeader(NATIVE_HEADERS, map);
        }
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        if (!ObjectUtils.nullSafeEquals(values, (Object)this.getHeader(name))) {
            this.setModified(true);
            map.put(name, values);
        }
    }

    public void addNativeHeader(String name, String value) {
        List<String> values;
        Assert.state((boolean)this.isMutable(), (String)"Already immutable");
        if (value == null) {
            return;
        }
        LinkedMultiValueMap nativeHeaders = this.getNativeHeaders();
        if (nativeHeaders == null) {
            nativeHeaders = new LinkedMultiValueMap(4);
            this.setHeader(NATIVE_HEADERS, nativeHeaders);
        }
        if ((values = nativeHeaders.get(name)) == null) {
            values = new LinkedList<String>();
            nativeHeaders.put(name, values);
        }
        values.add(value);
        this.setModified(true);
    }

    public List<String> removeNativeHeader(String name) {
        Assert.state((boolean)this.isMutable(), (String)"Already immutable");
        Map<String, List<String>> nativeHeaders = this.getNativeHeaders();
        if (nativeHeaders == null) {
            return null;
        }
        return nativeHeaders.remove(name);
    }
}

