/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.base64;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;

public class Base64 {
    byte[] data;
    static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static byte[] values;

    public Base64(byte[] data) {
        this.data = data;
    }

    public static final byte[] decodeBase64(String string) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(string.length() * 2 / 3);
        StringReader rdr = new StringReader(string.trim());
        try {
            Base64.decode(rdr, bout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public static final void decode(Reader rdr, OutputStream out) throws Exception {
        int c;
        int register = 0;
        int i = 0;
        int pads = 0;
        byte[] test = new byte[3];
        while ((c = rdr.read()) >= 0) {
            if (c > 127) {
                throw new IllegalArgumentException("Invalid base64 character in " + rdr + ", character value > 128 ");
            }
            byte v = 0;
            if (c == 61) {
                ++pads;
            } else {
                v = values[c];
                if (v < 0) {
                    throw new IllegalArgumentException("Invalid base64 character in " + rdr + ", " + c);
                }
            }
            register <<= 6;
            test[2] = (byte)((register |= v) & 0xFF);
            test[1] = (byte)(register >> 8 & 0xFF);
            test[0] = (byte)(register >> 16 & 0xFF);
            if (++i % 4 != 0) continue;
            Base64.flush(out, register, pads);
            register = 0;
            pads = 0;
        }
    }

    private static void flush(OutputStream out, int register, int pads) throws IOException {
        switch (pads) {
            case 0: {
                out.write(0xFF & register >> 16);
                out.write(0xFF & register >> 8);
                out.write(0xFF & register >> 0);
                break;
            }
            case 1: {
                out.write(0xFF & register >> 16);
                out.write(0xFF & register >> 8);
                break;
            }
            case 2: {
                out.write(0xFF & register >> 16);
            }
        }
    }

    public Base64(String s) {
        this.data = Base64.decodeBase64(s);
    }

    public String toString() {
        return Base64.encodeBase64(this.data);
    }

    public static String encodeBase64(byte[] data) {
        StringWriter sw = new StringWriter();
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        try {
            Base64.encode(bin, sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)sw).toString();
    }

    public Object toData() {
        return this.data;
    }

    public static void encode(InputStream in, Appendable sb) throws IOException {
        int mod;
        int buf = 0;
        int bits = 0;
        int out = 0;
        while (true) {
            if (bits >= 6) {
                int v = 0x3F & buf >> (bits -= 6);
                sb.append(alphabet.charAt(v));
                ++out;
                continue;
            }
            int c = in.read();
            if (c < 0) break;
            buf <<= 8;
            buf |= 0xFF & c;
            bits += 8;
        }
        if (bits != 0) {
            sb.append(alphabet.charAt(0x3F & buf << 6 - bits));
            ++out;
        }
        if ((mod = 4 - out % 4) != 4) {
            for (int i = 0; i < mod; ++i) {
                sb.append('=');
            }
        }
    }

    static {
        int i;
        values = new byte[128];
        for (i = 0; i < values.length; ++i) {
            Base64.values[i] = -1;
        }
        for (i = 0; i < alphabet.length(); ++i) {
            char c = alphabet.charAt(i);
            Base64.values[c] = (byte)i;
        }
    }
}

