/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import java.util.TreeMap;
import org.apache.karaf.scr.command.ScrUtils;
import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.scr.command.completer.DetailsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.osgi.framework.Bundle;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;

@Command(scope="scr", name="details", description="Display available components")
@Service
public class DetailsAction
extends ScrActionSupport {
    @Argument(index=0, name="name", description="The component name", required=true, multiValued=false)
    @Completion(value=DetailsCompleter.class)
    String name;

    @Override
    protected Object doScrAction(ServiceComponentRuntime serviceComponentRuntime) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing the Details Action");
        }
        System.out.println(SimpleAnsi.INTENSITY_BOLD + "Component Details" + SimpleAnsi.INTENSITY_NORMAL);
        for (ComponentDescriptionDTO component : serviceComponentRuntime.getComponentDescriptionDTOs(new Bundle[0])) {
            for (ComponentConfigurationDTO config : serviceComponentRuntime.getComponentConfigurationDTOs(component)) {
                if (!this.name.equals(component.name)) continue;
                this.printDetail("  Name                : ", component.name);
                this.printDetail("  State               : ", ScrUtils.getState(config.state));
                TreeMap map = new TreeMap(component.properties);
                if (!map.isEmpty()) {
                    System.out.println(SimpleAnsi.INTENSITY_BOLD + "  Properties          : " + SimpleAnsi.INTENSITY_NORMAL);
                    for (Object key : map.keySet()) {
                        Object value = map.get(key);
                        this.printDetail("    ", key + "=" + value);
                    }
                }
                ReferenceDTO[] references = component.references;
                System.out.println(SimpleAnsi.INTENSITY_BOLD + "References" + SimpleAnsi.INTENSITY_NORMAL);
                for (ReferenceDTO reference : ScrUtils.emptyIfNull(ReferenceDTO.class, references)) {
                    ServiceReferenceDTO[] boundServices = null;
                    boolean satisfied = true;
                    for (SatisfiedReferenceDTO satisfiedReferenceDTO : config.satisfiedReferences) {
                        if (!satisfiedReferenceDTO.name.equals(reference.name)) continue;
                        boundServices = satisfiedReferenceDTO.boundServices;
                        satisfied = true;
                    }
                    for (SatisfiedReferenceDTO satisfiedReferenceDTO : config.unsatisfiedReferences) {
                        if (!satisfiedReferenceDTO.name.equals(reference.name)) continue;
                        boundServices = satisfiedReferenceDTO.targetServices;
                        satisfied = false;
                    }
                    this.printDetail("  Reference           : ", reference.name);
                    this.printDetail("    State             : ", satisfied ? "satisfied" : "unsatisfied");
                    this.printDetail("    Cardinality       : ", reference.cardinality);
                    this.printDetail("    Policy            : ", reference.policy);
                    this.printDetail("    PolicyOption      : ", reference.policyOption);
                    for (SatisfiedReferenceDTO satisfiedReferenceDTO : ScrUtils.emptyIfNull(ServiceReferenceDTO.class, boundServices)) {
                        StringBuffer b = new StringBuffer();
                        b.append("Bound Service ID ");
                        b.append(satisfiedReferenceDTO.properties.get("service.id"));
                        String componentName = (String)satisfiedReferenceDTO.properties.get("component.name");
                        if (componentName == null && (componentName = (String)satisfiedReferenceDTO.properties.get("service.pid")) == null) {
                            componentName = (String)satisfiedReferenceDTO.properties.get("service.description");
                        }
                        if (componentName != null) {
                            b.append(" (");
                            b.append(componentName);
                            b.append(")");
                        }
                        this.printDetail("    Service Reference : ", b.toString());
                    }
                    if (ScrUtils.emptyIfNull(ServiceReferenceDTO.class, boundServices).length != 0) continue;
                    this.printDetail("    Service Reference : ", "No Services bound");
                }
            }
        }
        return null;
    }

    private void printDetail(String header, String value) {
        System.out.println(SimpleAnsi.INTENSITY_BOLD + header + SimpleAnsi.INTENSITY_NORMAL + value);
    }
}

