/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;

public class ProtocolHandlers {
    private final Map<String, ProtocolHandler> handlers = new LinkedHashMap<String, ProtocolHandler>();

    protected ProtocolHandlers() {
    }

    public ProtocolHandler put(ProtocolHandler protocolHandler) {
        return this.handlers.put(protocolHandler.getName(), protocolHandler);
    }

    public ProtocolHandler remove(String name) {
        return this.handlers.remove(name);
    }

    public void clear() {
        this.handlers.clear();
    }

    public ProtocolHandler find(Request request, Response response) {
        for (ProtocolHandler handler : this.handlers.values()) {
            if (!handler.accept(request, response)) continue;
            return handler;
        }
        return null;
    }
}

