/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import org.apache.karaf.config.core.impl.MetatypeCallable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.MetaTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaServiceCaller {
    private static Logger LOG = LoggerFactory.getLogger(MetaServiceCaller.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withMetaTypeService(BundleContext context, MetatypeCallable<T> callable) {
        try {
            ServiceReference ref = context.getServiceReference(MetaTypeService.class);
            try {
                MetaTypeService metaService = (MetaTypeService)context.getService(ref);
                T t = callable.callWith(metaService);
                return t;
            }
            finally {
                context.ungetService(ref);
            }
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("No Metatype Service present");
            return null;
        }
    }
}

