/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.converter;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.karaf.shell.support.converter.GenericType;
import org.apache.karaf.shell.support.converter.ReifiedType;

public class DefaultConverter {
    private Object loader;
    private static final Map<Class, Class> primitives = new HashMap<Class, Class>();

    public DefaultConverter(Object loader) {
        this.loader = loader;
    }

    public Object convert(Object source, Type target) throws Exception {
        return this.convert(source, new GenericType(target));
    }

    public Object convert(Object fromValue, ReifiedType type) throws Exception {
        if (fromValue == null) {
            return null;
        }
        if (DefaultConverter.isAssignable(fromValue, type)) {
            return fromValue;
        }
        Object value = this.convertWithConverters(fromValue, type);
        if (value == null) {
            if (String.class.isAssignableFrom(this.toClass(type))) {
                return fromValue.toString();
            }
            if (fromValue instanceof Number && Number.class.isAssignableFrom(DefaultConverter.unwrap(this.toClass(type)))) {
                return this.convertToNumber((Number)fromValue, this.toClass(type));
            }
            if (fromValue instanceof String) {
                return this.convertFromString((String)fromValue, this.toClass(type), this.loader);
            }
            if (this.toClass(type).isArray() && (fromValue instanceof Collection || fromValue.getClass().isArray())) {
                return this.convertToArray(fromValue, type);
            }
            if (Map.class.isAssignableFrom(this.toClass(type)) && (fromValue instanceof Map || fromValue instanceof Dictionary)) {
                return this.convertToMap(fromValue, type);
            }
            if (Dictionary.class.isAssignableFrom(this.toClass(type)) && (fromValue instanceof Map || fromValue instanceof Dictionary)) {
                return this.convertToDictionary(fromValue, type);
            }
            if (Collection.class.isAssignableFrom(this.toClass(type)) && (fromValue instanceof Collection || fromValue.getClass().isArray())) {
                return this.convertToCollection(fromValue, type);
            }
            throw new Exception("Unable to convert value " + fromValue + " to type " + type);
        }
        return value;
    }

    private Object convertWithConverters(Object source, ReifiedType type) throws Exception {
        Object value = null;
        return value;
    }

    public Object convertToNumber(Number value, Class toType) throws Exception {
        if (AtomicInteger.class == (toType = DefaultConverter.unwrap(toType))) {
            return new AtomicInteger((Integer)this.convertToNumber(value, Integer.class));
        }
        if (AtomicLong.class == toType) {
            return new AtomicLong((Long)this.convertToNumber(value, Long.class));
        }
        if (Integer.class == toType) {
            return value.intValue();
        }
        if (Short.class == toType) {
            return value.shortValue();
        }
        if (Long.class == toType) {
            return value.longValue();
        }
        if (Float.class == toType) {
            return Float.valueOf(value.floatValue());
        }
        if (Double.class == toType) {
            return value.doubleValue();
        }
        if (Byte.class == toType) {
            return value.byteValue();
        }
        if (BigInteger.class == toType) {
            return new BigInteger(value.toString());
        }
        if (BigDecimal.class == toType) {
            return new BigDecimal(value.toString());
        }
        throw new Exception("Unable to convert number " + value + " to " + toType);
    }

    public Object convertFromString(String value, Class toType, Object loader) throws Exception {
        if (ReifiedType.class == (toType = DefaultConverter.unwrap(toType))) {
            try {
                return GenericType.parse(value, loader);
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Unable to convert", e);
            }
        }
        if (Class.class == toType) {
            try {
                return GenericType.parse(value, loader).getRawClass();
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Unable to convert", e);
            }
        }
        if (Locale.class == toType) {
            String[] tokens = value.split("_");
            if (tokens.length == 1) {
                return new Locale(tokens[0]);
            }
            if (tokens.length == 2) {
                return new Locale(tokens[0], tokens[1]);
            }
            if (tokens.length == 3) {
                return new Locale(tokens[0], tokens[1], tokens[2]);
            }
            throw new Exception("Invalid locale string:" + value);
        }
        if (Pattern.class == toType) {
            return Pattern.compile(value);
        }
        if (Properties.class == toType) {
            Properties props = new Properties();
            ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes("UTF8"));
            props.load(in);
            return props;
        }
        if (Boolean.class == toType) {
            if ("yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("no".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Invalid boolean value: " + value);
        }
        if (Integer.class == toType) {
            return Integer.valueOf(value);
        }
        if (Short.class == toType) {
            return Short.valueOf(value);
        }
        if (Long.class == toType) {
            return Long.valueOf(value);
        }
        if (Float.class == toType) {
            return Float.valueOf(value);
        }
        if (Double.class == toType) {
            return Double.valueOf(value);
        }
        if (Character.class == toType) {
            if (value.length() == 6 && value.startsWith("\\u")) {
                int code = Integer.parseInt(value.substring(2), 16);
                return Character.valueOf((char)code);
            }
            if (value.length() == 1) {
                return Character.valueOf(value.charAt(0));
            }
            throw new Exception("Invalid value for character type: " + value);
        }
        if (Byte.class == toType) {
            return Byte.valueOf(value);
        }
        if (Enum.class.isAssignableFrom(toType)) {
            return Enum.valueOf(toType, value);
        }
        if (URI.class == toType) {
            return DefaultConverter.createUri(value);
        }
        return DefaultConverter.createObject(value, toType);
    }

    private static URI createUri(String value) throws Exception {
        return URI.create(value.replaceAll("\"", "%22"));
    }

    private static Object createObject(String value, Class type) throws Exception {
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            throw new Exception("Unable to convert value " + value + " to type " + type + ". Type " + type + " is an interface or an abstract class");
        }
        Constructor constructor = null;
        try {
            constructor = type.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to convert to " + type);
        }
        try {
            return constructor.newInstance(value);
        }
        catch (Exception e) {
            throw new Exception("Unable to convert ", DefaultConverter.getRealCause(e));
        }
    }

    private static Throwable getRealCause(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }

    private Object convertToCollection(Object obj, ReifiedType type) throws Exception {
        ReifiedType valueType = type.getActualTypeArgument(0);
        Collection newCol = (Collection)DefaultConverter.getCollection(this.toClass(type)).newInstance();
        if (obj.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(obj); ++i) {
                try {
                    newCol.add(this.convert(Array.get(obj, i), valueType));
                    continue;
                }
                catch (Exception t) {
                    throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting array element)", t);
                }
            }
        } else {
            for (Object item : (Collection)obj) {
                try {
                    newCol.add(this.convert(item, valueType));
                }
                catch (Exception t) {
                    throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting collection entry)", t);
                }
            }
        }
        return newCol;
    }

    private Object convertToDictionary(Object obj, ReifiedType type) throws Exception {
        ReifiedType keyType = type.getActualTypeArgument(0);
        ReifiedType valueType = type.getActualTypeArgument(1);
        Hashtable<Object, Object> newDic = new Hashtable<Object, Object>();
        if (obj instanceof Dictionary) {
            Dictionary dic = (Dictionary)obj;
            Enumeration keyEnum = dic.keys();
            while (keyEnum.hasMoreElements()) {
                Object key = keyEnum.nextElement();
                try {
                    ((Dictionary)newDic).put(this.convert(key, keyType), this.convert(dic.get(key), valueType));
                }
                catch (Exception t) {
                    throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting map entry)", t);
                }
            }
        } else {
            for (Map.Entry e : ((Map)obj).entrySet()) {
                try {
                    ((Dictionary)newDic).put(this.convert(e.getKey(), keyType), this.convert(e.getValue(), valueType));
                }
                catch (Exception t) {
                    throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting map entry)", t);
                }
            }
        }
        return newDic;
    }

    private Object convertToMap(Object obj, ReifiedType type) throws Exception {
        ReifiedType keyType = type.getActualTypeArgument(0);
        ReifiedType valueType = type.getActualTypeArgument(1);
        Map newMap = (Map)DefaultConverter.getMap(this.toClass(type)).newInstance();
        if (obj instanceof Dictionary) {
            Dictionary dic = (Dictionary)obj;
            Enumeration keyEnum = dic.keys();
            while (keyEnum.hasMoreElements()) {
                Object key = keyEnum.nextElement();
                try {
                    newMap.put(this.convert(key, keyType), this.convert(dic.get(key), valueType));
                }
                catch (Exception t) {
                    throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting map entry)", t);
                }
            }
        } else {
            for (Map.Entry e : ((Map)obj).entrySet()) {
                try {
                    newMap.put(this.convert(e.getKey(), keyType), this.convert(e.getValue(), valueType));
                }
                catch (Exception t) {
                    throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting map entry)", t);
                }
            }
        }
        return newMap;
    }

    private Object convertToArray(Object obj, ReifiedType type) throws Exception {
        if (obj instanceof Collection) {
            obj = ((Collection)obj).toArray();
        }
        if (!obj.getClass().isArray()) {
            throw new Exception("Unable to convert from " + obj + " to " + type);
        }
        ReifiedType componentType = type.size() > 0 ? type.getActualTypeArgument(0) : new GenericType((Type)type.getRawClass().getComponentType());
        Object array = Array.newInstance(this.toClass(componentType), Array.getLength(obj));
        for (int i = 0; i < Array.getLength(obj); ++i) {
            try {
                Array.set(array, i, this.convert(Array.get(obj, i), componentType));
                continue;
            }
            catch (Exception t) {
                throw new Exception("Unable to convert from " + obj + " to " + type + "(error converting array element)", t);
            }
        }
        return array;
    }

    public static boolean isAssignable(Object source, ReifiedType target) {
        return source == null || target.size() == 0 && DefaultConverter.unwrap(target.getRawClass()).isAssignableFrom(DefaultConverter.unwrap(source.getClass()));
    }

    private static Class unwrap(Class c) {
        Class u = primitives.get(c);
        return u != null ? u : c;
    }

    private static Class getMap(Class type) {
        if (DefaultConverter.hasDefaultConstructor(type)) {
            return type;
        }
        if (SortedMap.class.isAssignableFrom(type)) {
            return TreeMap.class;
        }
        if (ConcurrentMap.class.isAssignableFrom(type)) {
            return ConcurrentHashMap.class;
        }
        return LinkedHashMap.class;
    }

    private static Class getCollection(Class type) {
        if (DefaultConverter.hasDefaultConstructor(type)) {
            return type;
        }
        if (SortedSet.class.isAssignableFrom(type)) {
            return TreeSet.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return LinkedHashSet.class;
        }
        if (List.class.isAssignableFrom(type)) {
            return ArrayList.class;
        }
        if (Queue.class.isAssignableFrom(type)) {
            return LinkedList.class;
        }
        return ArrayList.class;
    }

    private static boolean hasDefaultConstructor(Class type) {
        Constructor<?>[] constructors;
        if (!Modifier.isPublic(type.getModifiers())) {
            return false;
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return false;
        }
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    private Class toClass(ReifiedType type) {
        return type.getRawClass();
    }

    static {
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Boolean.TYPE, Boolean.class);
    }
}

