/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import java.util.Collection;
import java.util.List;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultErrorPageMapping;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.whiteboard.ErrorPageMapping;
import org.ops4j.pax.web.service.whiteboard.ServletMapping;
import org.ops4j.pax.web.service.whiteboard.WhiteboardServlet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletMappingWebElement
extends WebElement<ServletMapping>
implements WhiteboardServlet {
    private Logger LOG = LoggerFactory.getLogger(ServletMappingWebElement.class);
    private ServletMapping servletMapping;
    private List<DefaultErrorPageMapping> errorMappings;

    public ServletMappingWebElement(ServiceReference<ServletMapping> ref, ServletMapping servletMapping, List<DefaultErrorPageMapping> errorMappings) {
        super(ref);
        NullArgumentException.validateNotNull(servletMapping, "Servlet mapping");
        this.servletMapping = servletMapping;
        this.errorMappings = errorMappings;
        String servletName = servletMapping.getServletName();
        String alias = servletMapping.getAlias();
        String[] urlPatterns = servletMapping.getUrlPatterns();
        if (servletName != null && servletName.length() == 0) {
            this.LOG.warn("Registered servlet [{}] did not contain a valid servlet-name property.", (Object)this.getServiceID());
            this.valid = false;
        }
        if (alias != null && urlPatterns != null && urlPatterns.length != 0) {
            this.LOG.warn("Registered servlet [{}] cannot have both alias and url patterns.", (Object)this.getServiceID());
            this.valid = false;
        } else if (alias == null && urlPatterns == null) {
            this.LOG.warn("Registered servlet [{}] did not contain a valid alias or url patterns property.", (Object)this.getServiceID());
            this.valid = false;
        } else if (alias != null && alias.trim().length() == 0) {
            this.LOG.warn("Registered servlet [{}] did not contain a valid alias property.", (Object)this.getServiceID());
            this.valid = false;
        }
    }

    @Override
    public void register(WebContainer webContainer, HttpContext httpContext) throws Exception {
        if (this.servletMapping.getAlias() != null) {
            webContainer.registerServlet(this.servletMapping.getAlias(), this.servletMapping.getServlet(), DictionaryUtils.adapt(this.servletMapping.getInitParams()), httpContext);
        } else {
            webContainer.registerServlet(this.servletMapping.getServlet(), this.servletMapping.getServletName(), this.servletMapping.getUrlPatterns(), DictionaryUtils.adapt(this.servletMapping.getInitParams()), this.servletMapping.getLoadOnStartup(), this.servletMapping.getAsyncSupported(), this.servletMapping.getMultipartConfig(), httpContext);
        }
        if (this.errorMappings != null) {
            for (DefaultErrorPageMapping errorPageMapping : this.errorMappings) {
                webContainer.registerErrorPage(errorPageMapping.getError(), this.servletMapping.getAlias(), httpContext);
            }
        }
    }

    @Override
    public void unregister(WebContainer webContainer, HttpContext httpContext) {
        if (this.servletMapping.getAlias() != null) {
            webContainer.unregister(this.servletMapping.getAlias());
        } else {
            webContainer.unregisterServlet(this.servletMapping.getServlet());
        }
    }

    @Override
    public String getHttpContextId() {
        return this.servletMapping.getHttpContextId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mapping=" + this.servletMapping + "}";
    }

    public ServletMapping getServletMapping() {
        return this.servletMapping;
    }

    public Collection<? extends ErrorPageMapping> getErrorPageMappings() {
        return this.errorMappings;
    }

    public boolean isAliasRegistration() {
        return this.servletMapping.getAlias() != null && this.servletMapping.getUrlPatterns() == null;
    }
}

