/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.support.AbstractMethodArgumentResolutionException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

public class MethodArgumentNotValidException
extends AbstractMethodArgumentResolutionException {
    private final BindingResult bindingResult;

    public MethodArgumentNotValidException(Message<?> message, MethodParameter parameter) {
        this(message, parameter, (BindingResult)null);
    }

    public MethodArgumentNotValidException(Message<?> message, MethodParameter parameter, BindingResult bindingResult) {
        super(message, parameter, MethodArgumentNotValidException.getMethodParamMessage(parameter) + MethodArgumentNotValidException.getValidationErrorMessage(bindingResult));
        this.bindingResult = bindingResult;
    }

    public final BindingResult getBindingResult() {
        return this.bindingResult;
    }

    private static String getValidationErrorMessage(BindingResult bindingResult) {
        if (bindingResult != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(", with ").append(bindingResult.getErrorCount()).append(" error(s): ");
            for (ObjectError error : bindingResult.getAllErrors()) {
                sb.append("[").append(error).append("] ");
            }
            return sb.toString();
        }
        return "";
    }
}

