/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public interface ValueRef {
    public TypedValue getValue();

    public void setValue(Object var1);

    public boolean isWritable();

    public static class TypedValueHolderValueRef
    implements ValueRef {
        private TypedValue typedValue;
        private SpelNodeImpl node;

        public TypedValueHolderValueRef(TypedValue typedValue, SpelNodeImpl node) {
            this.typedValue = typedValue;
            this.node = node;
        }

        public TypedValue getValue() {
            return this.typedValue;
        }

        public void setValue(Object newValue) {
            throw new SpelEvaluationException(this.node.pos, SpelMessage.NOT_ASSIGNABLE, this.node.toStringAST());
        }

        public boolean isWritable() {
            return false;
        }
    }

    public static class NullValueRef
    implements ValueRef {
        static NullValueRef instance = new NullValueRef();

        public TypedValue getValue() {
            return TypedValue.NULL;
        }

        public void setValue(Object newValue) {
            throw new SpelEvaluationException(0, SpelMessage.NOT_ASSIGNABLE, "null");
        }

        public boolean isWritable() {
            return false;
        }
    }
}

