/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jsonschema.internal;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanValidationAnnotationIntrospector
extends AnnotationIntrospector {
    private static final transient Logger LOG = LoggerFactory.getLogger(BeanValidationAnnotationIntrospector.class);
    protected final TypeFactory typeFactory;

    public Version version() {
        return new Version(1, 1, 0, "", "io.hawt", "hawtio-json-schema-mbean");
    }

    public BeanValidationAnnotationIntrospector(TypeFactory typeFactory) {
        this.typeFactory = typeFactory == null ? TypeFactory.defaultInstance() : typeFactory;
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        int fieldModifiers;
        Class declaringClass;
        String fieldName;
        Field field;
        AnnotatedMethod method;
        String methodName;
        Member member = m.getMember();
        int modifiers = member.getModifiers();
        if (Modifier.isTransient(modifiers)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring transient member " + m);
            }
            return true;
        }
        if (m instanceof AnnotatedMethod && (methodName = (method = (AnnotatedMethod)m).getName()).startsWith("get") && method.getParameterCount() == 0 && (field = BeanValidationAnnotationIntrospector.findField(fieldName = Introspector.decapitalize(methodName.substring(3)), declaringClass = method.getDeclaringClass())) != null && Modifier.isTransient(fieldModifiers = field.getModifiers())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring member " + m + " due to transient field called " + fieldName);
            }
            return true;
        }
        return super.hasIgnoreMarker(m);
    }

    protected static Field findField(String fieldName, Class<?> declaringClass) {
        try {
            return declaringClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = declaringClass.getSuperclass();
            if (superclass != null && superclass != declaringClass) {
                return BeanValidationAnnotationIntrospector.findField(fieldName, superclass);
            }
            return null;
        }
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        NotNull annotation = (NotNull)m.getAnnotation(NotNull.class);
        if (annotation == null) {
            return null;
        }
        return Boolean.TRUE;
    }
}

