/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.karaf.management.internal.BulkRequestContext;
import org.apache.karaf.management.internal.EventAdminLogger;
import org.apache.karaf.management.internal.EventAdminMBeanServerWrapper;
import org.apache.karaf.management.internal.MBeanInvocationHandler;
import org.apache.karaf.service.guard.tools.ACLConfigurationParser;
import org.apache.karaf.util.jaas.JaasHelper;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafMBeanServerGuard
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KarafMBeanServerGuard.class);
    private static final String JMX_ACL_PID_PREFIX = "jmx.acl";
    private static final String JMX_ACL_WHITELIST = "jmx.acl.whitelist";
    private static final String JMX_ACL_DETAILED_MESSAGE = "jmx.acl.detailed.message";
    private static final String JMX_OBJECTNAME_PROPERTY_WILDCARD = "_";
    private static final Comparator<String[]> WILDCARD_PID_COMPARATOR = new WildcardPidComparator();
    private static final String INVOKE = "invoke";
    private static final String[] INVOKE_SIG = new String[]{ObjectName.class.getName(), String.class.getName(), Object[].class.getName(), String[].class.getName()};
    private ConfigurationAdmin configAdmin;
    private EventAdminLogger logger;

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public EventAdminLogger getLogger() {
        return this.logger;
    }

    public void setLogger(EventAdminLogger logger) {
        this.logger = logger;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getParameterTypes().length == 0) {
            return null;
        }
        if (!ObjectName.class.isAssignableFrom(method.getParameterTypes()[0])) {
            return null;
        }
        MBeanServer mbs = (MBeanServer)proxy;
        if (mbs != null && Proxy.getInvocationHandler(mbs) instanceof MBeanInvocationHandler) {
            mbs = ((MBeanInvocationHandler)Proxy.getInvocationHandler(mbs)).getDelegate();
        }
        if (mbs instanceof EventAdminMBeanServerWrapper) {
            mbs = ((EventAdminMBeanServerWrapper)mbs).getDelegate();
        }
        ObjectName objectName = (ObjectName)args[0];
        if ("getAttribute".equals(method.getName())) {
            this.handleGetAttribute(mbs, objectName, (String)args[1]);
        } else if ("getAttributes".equals(method.getName())) {
            this.handleGetAttributes(mbs, objectName, (String[])args[1]);
        } else if ("setAttribute".equals(method.getName())) {
            this.handleSetAttribute(mbs, objectName, (Attribute)args[1]);
        } else if ("setAttributes".equals(method.getName())) {
            this.handleSetAttributes(mbs, objectName, (AttributeList)args[1]);
        } else if (INVOKE.equals(method.getName())) {
            this.handleInvoke(objectName, (String)args[1], (Object[])args[2], (String[])args[3]);
        }
        return null;
    }

    public boolean canInvoke(MBeanServer mbeanServer, ObjectName objectName) throws JMException, IOException {
        return this.canInvoke(null, mbeanServer, objectName);
    }

    public boolean canInvoke(BulkRequestContext context, MBeanServer mbeanServer, ObjectName objectName) throws JMException, IOException {
        MBeanInfo info = mbeanServer.getMBeanInfo(objectName);
        for (MBeanOperationInfo mBeanOperationInfo : info.getOperations()) {
            ArrayList<String> sig = new ArrayList<String>();
            for (MBeanParameterInfo param : mBeanOperationInfo.getSignature()) {
                sig.add(param.getType());
            }
            if (!this.canInvoke(context, objectName, mBeanOperationInfo.getName(), sig.toArray(new String[0]))) continue;
            return true;
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : info.getAttributes()) {
            if (((MBeanAttributeInfo)mBeanFeatureInfo).isReadable() && this.canInvoke(context, objectName, ((MBeanAttributeInfo)mBeanFeatureInfo).isIs() ? "is" : "get" + mBeanFeatureInfo.getName(), new String[0])) {
                return true;
            }
            if (!((MBeanAttributeInfo)mBeanFeatureInfo).isWritable() || !this.canInvoke(context, objectName, "set" + mBeanFeatureInfo.getName(), new String[]{((MBeanAttributeInfo)mBeanFeatureInfo).getType()})) continue;
            return true;
        }
        return false;
    }

    public boolean canInvoke(MBeanServer mbeanServer, ObjectName objectName, String methodName) throws JMException, IOException {
        return this.canInvoke(null, mbeanServer, objectName, methodName);
    }

    public boolean canInvoke(BulkRequestContext context, MBeanServer mbeanServer, ObjectName objectName, String methodName) throws JMException, IOException {
        methodName = methodName.trim();
        MBeanInfo info = mbeanServer.getMBeanInfo(objectName);
        for (MBeanOperationInfo mBeanOperationInfo : info.getOperations()) {
            if (!methodName.equals(mBeanOperationInfo.getName())) continue;
            ArrayList<String> sig = new ArrayList<String>();
            for (MBeanParameterInfo param : mBeanOperationInfo.getSignature()) {
                sig.add(param.getType());
            }
            if (!this.canInvoke(context, objectName, mBeanOperationInfo.getName(), sig.toArray(new String[0]))) continue;
            return true;
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : info.getAttributes()) {
            String attrName = mBeanFeatureInfo.getName();
            if (methodName.equals("is" + attrName) || methodName.equals("get" + attrName)) {
                return this.canInvoke(context, objectName, methodName, new String[0]);
            }
            if (!methodName.equals("set" + attrName)) continue;
            return this.canInvoke(context, objectName, methodName, new String[]{((MBeanAttributeInfo)mBeanFeatureInfo).getType()});
        }
        return false;
    }

    public boolean canInvoke(MBeanServer mbeanServer, ObjectName objectName, String methodName, String[] signature) throws IOException {
        return this.canInvoke(null, mbeanServer, objectName, methodName, signature);
    }

    public boolean canInvoke(BulkRequestContext context, MBeanServer mbeanServer, ObjectName objectName, String methodName, String[] signature) throws IOException {
        return this.canInvoke(context, objectName, methodName, signature);
    }

    private boolean canInvoke(BulkRequestContext context, ObjectName objectName, String methodName, String[] signature) throws IOException {
        if (context == null) {
            context = BulkRequestContext.newContext(this.configAdmin);
        }
        if (this.canBypassRBAC(context, objectName, methodName)) {
            return true;
        }
        for (String role : this.getRequiredRoles(context, objectName, methodName, signature)) {
            if (!JaasHelper.currentUserHasRole(context.getPrincipals(), role)) continue;
            return true;
        }
        return false;
    }

    private void handleGetAttribute(MBeanServer proxy, ObjectName objectName, String attributeName) throws JMException, IOException {
        MBeanInfo info = proxy.getMBeanInfo(objectName);
        String prefix = null;
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            if (!attr.getName().equals(attributeName)) continue;
            prefix = attr.isIs() ? "is" : "get";
        }
        if (prefix == null) {
            LOG.debug("Attribute " + attributeName + " can not be found for MBean " + objectName.toString());
        } else {
            this.handleInvoke(null, objectName, prefix + attributeName, new Object[0], new String[0]);
        }
    }

    private void handleGetAttributes(MBeanServer proxy, ObjectName objectName, String[] attributeNames) throws JMException, IOException {
        for (String attr : attributeNames) {
            this.handleGetAttribute(proxy, objectName, attr);
        }
    }

    private void handleSetAttribute(MBeanServer proxy, ObjectName objectName, Attribute attribute) throws JMException, IOException {
        String dataType = null;
        MBeanInfo info = proxy.getMBeanInfo(objectName);
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            if (!attr.getName().equals(attribute.getName())) continue;
            dataType = attr.getType();
            break;
        }
        if (dataType == null) {
            throw new IllegalStateException("Attribute data type can not be found");
        }
        this.handleInvoke(null, objectName, "set" + attribute.getName(), new Object[]{attribute.getValue()}, new String[]{dataType});
    }

    private void handleSetAttributes(MBeanServer proxy, ObjectName objectName, AttributeList attributes) throws JMException, IOException {
        for (Attribute attr : attributes.asList()) {
            this.handleSetAttribute(proxy, objectName, attr);
        }
    }

    private boolean canBypassRBAC(BulkRequestContext context, ObjectName objectName, String operationName) {
        ArrayList<String> allBypassObjectName = new ArrayList<String>();
        List<Dictionary<String, Object>> configs = context.getWhitelistProperties();
        for (Dictionary<String, Object> config : configs) {
            Enumeration<String> keys = config.keys();
            while (keys.hasMoreElements()) {
                String element = keys.nextElement();
                allBypassObjectName.add(element);
            }
        }
        for (String pid : this.iterateDownPids(this.getNameSegments(objectName))) {
            if (pid.equals(JMX_ACL_PID_PREFIX)) continue;
            for (String bypassObjectName : allBypassObjectName) {
                String[] objectNameAndMethod = bypassObjectName.split(";");
                if (!(objectNameAndMethod.length > 1 ? bypassObjectName.equals(pid.substring("jmx.acl.".length()) + ";" + operationName) : bypassObjectName.equals(pid.substring("jmx.acl.".length())))) continue;
                return true;
            }
        }
        return false;
    }

    void handleInvoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws IOException {
        this.handleInvoke(null, objectName, operationName, params, signature);
    }

    void handleInvoke(BulkRequestContext context, ObjectName objectName, String operationName, Object[] params, String[] signature) throws IOException {
        if (context == null) {
            context = BulkRequestContext.newContext(this.configAdmin);
        }
        if (this.canBypassRBAC(context, objectName, operationName)) {
            return;
        }
        for (String role : this.getRequiredRoles(context, objectName, operationName, params, signature)) {
            if (!JaasHelper.currentUserHasRole(role)) continue;
            return;
        }
        if (Boolean.valueOf(System.getProperty(JMX_ACL_DETAILED_MESSAGE, "false")).booleanValue()) {
            this.printDetailedMessage(context, objectName, operationName, params, signature);
        }
        SecurityException se = new SecurityException("Insufficient roles/credentials for operation");
        if (this.logger != null) {
            this.logger.log(INVOKE, INVOKE_SIG, null, se, objectName, operationName, signature, params);
        }
        throw se;
    }

    /*
     * WARNING - void declaration
     */
    private void printDetailedMessage(BulkRequestContext context, ObjectName objectName, String operationName, Object[] params, String[] signature) throws IOException {
        void var8_14;
        void var8_12;
        String expectedRoles = "";
        for (String string : this.getRequiredRoles(context, objectName, operationName, params, signature)) {
            if (expectedRoles.length() != 0) {
                expectedRoles = expectedRoles + ", " + string;
                continue;
            }
            expectedRoles = string;
        }
        String currentRoles = "";
        for (Principal p : context.getPrincipals()) {
            if (!p.getClass().getName().endsWith("RolePrincipal")) continue;
            if (currentRoles.length() != 0) {
                currentRoles = currentRoles + ", " + p.getName();
                continue;
            }
            currentRoles = p.getName();
        }
        Object var8_10 = null;
        for (String pid : this.iterateDownPids(this.getNameSegments(objectName))) {
            ArrayList<String> roles;
            Dictionary<String, Object> config;
            ACLConfigurationParser.Specificity s;
            String generalPid = this.getGeneralPid(context.getAllPids(), pid);
            if (generalPid.length() <= 0 || (s = ACLConfigurationParser.getRolesForInvocation(operationName, params, signature, config = context.getConfiguration(generalPid), roles = new ArrayList<String>())) == ACLConfigurationParser.Specificity.NO_MATCH) continue;
            String string = generalPid;
            break;
        }
        if (var8_12 == null) {
            String string = this.iterateDownPids(this.getNameSegments(objectName)).get(0);
        }
        LOG.debug("The current roles are '" + currentRoles + "', however the expected roles are '" + expectedRoles + "'. To make the call pass RBAC check, please add current role into entry '" + operationName + "' of file " + (String)var8_14 + ".cfg");
    }

    List<String> getRequiredRoles(ObjectName objectName, String methodName, String[] signature) throws IOException {
        return this.getRequiredRoles(BulkRequestContext.newContext(this.configAdmin), objectName, methodName, null, signature);
    }

    List<String> getRequiredRoles(BulkRequestContext context, ObjectName objectName, String methodName, String[] signature) throws IOException {
        return this.getRequiredRoles(context, objectName, methodName, null, signature);
    }

    List<String> getRequiredRoles(ObjectName objectName, String methodName, Object[] params, String[] signature) throws IOException {
        return this.getRequiredRoles(BulkRequestContext.newContext(this.configAdmin), objectName, methodName, params, signature);
    }

    List<String> getRequiredRoles(BulkRequestContext context, ObjectName objectName, String methodName, Object[] params, String[] signature) throws IOException {
        for (String pid : this.iterateDownPids(this.getNameSegments(objectName))) {
            ArrayList<String> roles;
            Dictionary<String, Object> config;
            ACLConfigurationParser.Specificity s;
            String generalPid = this.getGeneralPid(context.getAllPids(), pid);
            if (generalPid.length() <= 0 || (s = ACLConfigurationParser.getRolesForInvocation(methodName, params, signature, config = context.getConfiguration(generalPid), roles = new ArrayList<String>())) == ACLConfigurationParser.Specificity.NO_MATCH) continue;
            return roles;
        }
        return Collections.emptyList();
    }

    private String getGeneralPid(List<String> allPids, String pid) {
        String[] pidStrArray = pid.split(Pattern.quote("."));
        TreeSet<String[]> rets = new TreeSet<String[]>(WILDCARD_PID_COMPARATOR);
        for (String id : allPids) {
            String[] idStrArray = id.split(Pattern.quote("."));
            if (idStrArray.length != pidStrArray.length) continue;
            boolean match = true;
            for (int i = 0; i < idStrArray.length; ++i) {
                if (idStrArray[i].equals(JMX_OBJECTNAME_PROPERTY_WILDCARD) || idStrArray[i].equals(pidStrArray[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            rets.add(idStrArray);
        }
        Iterator it = rets.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String segment : (String[])it.next()) {
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(segment);
        }
        return buffer.toString();
    }

    private List<String> getNameSegments(ObjectName objectName) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(objectName.getDomain());
        for (String s : objectName.getKeyPropertyListString().split("[,]")) {
            int index = s.indexOf(61);
            if (index < 0) continue;
            String key = objectName.getKeyProperty(s.substring(0, index));
            if (s.substring(0, index).equals("type")) {
                segments.add(1, key);
                continue;
            }
            segments.add(key);
        }
        return segments;
    }

    private List<String> iterateDownPids(List<String> segments) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = segments.size(); i > 0; --i) {
            StringBuilder sb = new StringBuilder();
            sb.append(JMX_ACL_PID_PREFIX);
            for (int j = 0; j < i; ++j) {
                sb.append('.');
                sb.append(segments.get(j));
            }
            res.add(sb.toString());
        }
        res.add(JMX_ACL_PID_PREFIX);
        return res;
    }

    private static class WildcardPidComparator
    implements Comparator<String[]> {
        private WildcardPidComparator() {
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.length != o2.length) {
                return o1.length - o2.length;
            }
            for (int n = 0; n < o1.length; ++n) {
                if (o1[n].equals(o2[n])) continue;
                if (o1[n].equals(KarafMBeanServerGuard.JMX_OBJECTNAME_PROPERTY_WILDCARD)) {
                    return 1;
                }
                if (o2[n].equals(KarafMBeanServerGuard.JMX_OBJECTNAME_PROPERTY_WILDCARD)) {
                    return -1;
                }
                return o1[n].compareTo(o2[n]);
            }
            return 0;
        }
    }
}

