/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.FeaturePattern;
import org.apache.karaf.features.LocationPattern;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.Conditional;
import org.apache.karaf.features.internal.model.Dependency;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.processing.BundleReplacements;
import org.apache.karaf.features.internal.model.processing.FeatureReplacements;
import org.apache.karaf.features.internal.model.processing.FeaturesProcessing;
import org.apache.karaf.features.internal.model.processing.OverrideBundleDependency;
import org.apache.karaf.features.internal.service.Blacklist;
import org.apache.karaf.features.internal.service.FeaturesProcessingSerializer;
import org.apache.karaf.features.internal.service.FeaturesProcessor;
import org.apache.karaf.features.internal.service.FeaturesServiceConfig;
import org.apache.karaf.features.internal.service.Overrides;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesProcessorImpl
implements FeaturesProcessor {
    public static Logger LOG = LoggerFactory.getLogger(FeaturesProcessorImpl.class);
    private FeaturesProcessingSerializer serializer = new FeaturesProcessingSerializer();
    private FeaturesProcessing processing = new FeaturesProcessing();

    public FeaturesProcessorImpl(String featureModificationsURI, String featureProcessingVersions, Blacklist blacklistDefinitions, Set<String> overrides) {
        if (featureModificationsURI != null) {
            try (InputStream stream = new URL(featureModificationsURI).openStream();){
                File versionsProperties;
                Properties versions = new Properties();
                if (featureProcessingVersions != null && (versionsProperties = new File(new URL(featureProcessingVersions).getPath())).isFile()) {
                    try (InputStream propsStream = new URL(featureProcessingVersions).openStream();){
                        versions.load(propsStream);
                    }
                }
                this.processing = this.serializer.read(stream, versions);
            }
            catch (FileNotFoundException e) {
                LOG.debug("Can't find feature processing file (" + featureModificationsURI + "), skipping");
            }
            catch (Exception e) {
                LOG.warn("Can't initialize feature processor: " + e.getMessage());
            }
        }
        this.processing.postUnmarshall(blacklistDefinitions, overrides);
    }

    public FeaturesProcessorImpl(String featureModificationsURI, String featureProcessingVersions, String blacklistedURI, String overridesURI) {
        this(featureModificationsURI, featureProcessingVersions, new Blacklist(blacklistedURI), Overrides.loadOverrides(overridesURI));
    }

    public FeaturesProcessorImpl(FeaturesServiceConfig configuration) {
        this(configuration.featureModifications, configuration.featureProcessingVersions, configuration.blacklisted, configuration.overrides);
    }

    public void writeInstructions(OutputStream output) {
        this.serializer.write(this.processing, output);
    }

    public FeaturesProcessing getInstructions() {
        return this.processing;
    }

    public void addOverrides(Set<String> overrides) {
        this.processing.getBundleReplacements().getOverrideBundles().addAll(FeaturesProcessing.parseOverridesClauses(overrides));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process(Features features) {
        List<Feature> featureList = features.getFeature();
        for (int i = 0; i < featureList.size(); ++i) {
            Feature f = featureList.get(i);
            for (FeatureReplacements.OverrideFeature overrideFeature : this.getInstructions().getFeatureReplacements().getReplacements()) {
                if (!f.getId().equals(overrideFeature.getFeature().getId())) continue;
                switch (overrideFeature.getMode()) {
                    case REPLACE: {
                        featureList.set(i, overrideFeature.getFeature());
                        break;
                    }
                    case MERGE: {
                        f.getBundle().addAll(overrideFeature.getFeature().getBundle());
                        break;
                    }
                }
            }
        }
        for (Feature feature : features.getFeature()) {
            void var6_13;
            boolean allBlacklisted = features.isBlacklisted();
            feature.setBlacklisted(allBlacklisted || this.isFeatureBlacklisted(feature));
            for (Conditional conditional : feature.getConditional()) {
                boolean isConditionBlacklisted = false;
                for (String cond : conditional.getCondition()) {
                    isConditionBlacklisted |= this.isFeatureBlacklisted(new Feature(cond));
                }
                conditional.setBlacklisted(feature.isBlacklisted() || isConditionBlacklisted);
            }
            for (Dependency dep : feature.getFeature()) {
                dep.setBlacklisted(feature.isBlacklisted() || this.isFeatureBlacklisted(new Feature(dep.getName(), dep.getVersion())));
            }
            Object var6_12 = null;
            for (OverrideBundleDependency.OverrideFeatureDependency overrideFeatureDependency : this.getInstructions().getOverrideBundleDependency().getFeatures()) {
                FeaturePattern pattern = new FeaturePattern(overrideFeatureDependency.getName() + "/" + overrideFeatureDependency.getVersion());
                if (!pattern.matches(feature.getName(), feature.getVersion())) continue;
                Boolean bl = overrideFeatureDependency.isDependency();
            }
            this.processBundles(feature.getBundle(), allBlacklisted, (Boolean)var6_13);
            for (Conditional c : feature.getConditional()) {
                this.processBundles(c.getBundle(), allBlacklisted, (Boolean)var6_13);
            }
        }
    }

    private void processBundles(List<Bundle> bundles, boolean allBlacklisted, Boolean forceDependency) {
        for (Bundle bundle : bundles) {
            boolean bundleBlacklisted;
            boolean bl = bundleBlacklisted = allBlacklisted || this.isBundleBlacklisted(bundle.getLocation());
            if (bundleBlacklisted) {
                bundle.setBlacklisted(true);
                continue;
            }
            this.staticOverrideBundle(bundle);
            if (forceDependency != null) {
                bundle.setDependency(forceDependency);
                continue;
            }
            for (OverrideBundleDependency.OverrideDependency overrideBundleDependency : this.getInstructions().getOverrideBundleDependency().getBundles()) {
                LocationPattern pattern = new LocationPattern(overrideBundleDependency.getUri());
                if (!pattern.matches(bundle.getLocation())) continue;
                bundle.setDependency(overrideBundleDependency.isDependency());
            }
        }
    }

    private void staticOverrideBundle(Bundle bundle) {
        bundle.setOverriden(BundleInfo.BundleOverrideMode.NONE);
        for (BundleReplacements.OverrideBundle override : this.getInstructions().getBundleReplacements().getOverrideBundles()) {
            String originalLocation = bundle.getLocation();
            if (!override.getOriginalUriPattern().matches(originalLocation)) continue;
            LOG.debug("Overriding bundle location \"" + originalLocation + "\" with \"" + override.getReplacement() + "\"");
            bundle.setOriginalLocation(originalLocation);
            if (override.getMode() == BundleReplacements.BundleOverrideMode.MAVEN) {
                bundle.setOverriden(BundleInfo.BundleOverrideMode.MAVEN);
            } else {
                bundle.setOverriden(BundleInfo.BundleOverrideMode.OSGI);
            }
            bundle.setLocation(override.getReplacement());
        }
    }

    @Override
    public boolean isRepositoryBlacklisted(String uri) {
        for (LocationPattern lp : this.processing.getBlacklistedRepositoryLocationPatterns()) {
            if (!lp.matches(uri)) continue;
            return true;
        }
        return false;
    }

    private boolean isFeatureBlacklisted(Feature feature) {
        return this.getInstructions().getBlacklist().isFeatureBlacklisted(feature.getName(), feature.getVersion());
    }

    @Override
    public boolean isBundleBlacklisted(String location) {
        return this.getInstructions().getBlacklist().isBundleBlacklisted(location);
    }

    public boolean hasInstructions() {
        int count = 0;
        count += this.getInstructions().getBlacklistedRepositories().size();
        count += this.getInstructions().getBlacklistedFeatures().size();
        count += this.getInstructions().getBlacklistedBundles().size();
        count += this.getInstructions().getOverrideBundleDependency().getRepositories().size();
        count += this.getInstructions().getOverrideBundleDependency().getFeatures().size();
        count += this.getInstructions().getOverrideBundleDependency().getBundles().size();
        count += this.getInstructions().getBundleReplacements().getOverrideBundles().size();
        return (count += this.getInstructions().getFeatureReplacements().getReplacements().size()) > 0;
    }
}

