/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.features.distributed.kvstore.api.BlobStore;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorState;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.BlobStoreAwareMonitor;
import org.opennms.netmgt.threshd.MockSession;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluatorHighLow;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.api.ThresholdStateMonitor;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-testPostgresBlobStore.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class ThresholdStateIT {
    @Autowired
    private BlobStore blobStore;
    private final ThresholdingSession thresholdingSession = MockSession.getSession();
    private ThresholdStateMonitor monitor;

    @Before
    public void setup() {
        this.monitor = new BlobStoreAwareMonitor(this.blobStore);
        Mockito.when((Object)this.thresholdingSession.getThresholdStateMonitor()).thenReturn((Object)this.monitor);
        Mockito.when((Object)this.thresholdingSession.getBlobStore()).thenReturn((Object)this.blobStore);
    }

    @After
    public void cleanup() {
        this.blobStore.truncateContext("thresholding");
    }

    @Test
    public void canResumeWithState() {
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)this.getWrapper(), this.thresholdingSession);
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
        item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)this.getWrapper(), this.thresholdingSession);
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"second threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
    }

    @Test
    public void onlyAlwaysFetchesWhenDistributed() {
        BlobStore mockBlobStore = (BlobStore)Mockito.mock(BlobStore.class);
        Mockito.when((Object)this.thresholdingSession.getBlobStore()).thenReturn((Object)mockBlobStore);
        AbstractThresholdEvaluatorState.clearSerdesMap();
        AtomicInteger fetchesPerformed = new AtomicInteger(0);
        Mockito.when((Object)mockBlobStore.getLastUpdated(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString())).then(invocationOnMock -> {
            fetchesPerformed.incrementAndGet();
            return 0L;
        });
        Mockito.when((Object)mockBlobStore.get(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString())).then(invocationOnMock -> {
            fetchesPerformed.incrementAndGet();
            return new byte[0];
        });
        Mockito.when((Object)mockBlobStore.getIfStale(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString(), org.mockito.Matchers.anyLong())).then(invocationOnMock -> {
            fetchesPerformed.incrementAndGet();
            return new byte[0];
        });
        Mockito.when((Object)this.thresholdingSession.getBlobStore()).thenReturn((Object)mockBlobStore);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)this.getWrapper(), this.thresholdingSession);
        item.evaluate(100.0);
        item.evaluate(100.0);
        Assert.assertThat((Object)fetchesPerformed.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        Mockito.when((Object)this.thresholdingSession.isDistributed()).thenReturn((Object)true);
        fetchesPerformed.set(0);
        item.evaluate(100.0);
        item.evaluate(100.0);
        Assert.assertThat((Object)fetchesPerformed.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void canRetriggerAfterClear() {
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)this.getWrapper(), this.thresholdingSession);
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"second threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"third threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
        this.monitor.reinitializeStates();
        item.evaluate(100.0);
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"third threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
    }

    private ThresholdConfigWrapper getWrapper() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(2));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        return wrapper;
    }
}

