/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.mock.MockRpcClientFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.collectd.GenericIndexResource;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.Parameter;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.dao.api.IfLabel;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.MockDataCollectionConfig;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class CollectionResourceWrapperIT {
    private boolean m_ignoreWarnings = false;
    private LocationAwareSnmpClient m_locationAwareSnmpClient = new LocationAwareSnmpClientRpcImpl((RpcClientFactory)new MockRpcClientFactory());
    @Autowired
    private IfLabel m_ifLabelDao;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        CollectionResourceWrapper.s_cache.clear();
        MockLogAppender.setupLogging();
    }

    @After
    public void tearDown() throws Exception {
        if (!this.m_ignoreWarnings) {
            MockLogAppender.assertNoWarningsOrGreater();
        }
    }

    @Test
    public void testGetGaugeValue() throws Exception {
        SnmpCollectionAgent agent = this.createCollectionAgent();
        SnmpCollectionResource resource = this.createNodeResource(agent);
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        SnmpAttribute attribute = this.addAttributeToCollectionResource(resource, "myGauge", AttributeType.GAUGE, "0", "100");
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        CollectionResourceWrapper wrapper = this.createWrapper(resource, attributes);
        Assert.assertEquals((Object)100.0, (Object)wrapper.getAttributeValue("myGauge"));
        Assert.assertEquals((Object)100.0, (Object)wrapper.getAttributeValue("myGauge"));
        Assert.assertEquals((Object)100.0, (Object)wrapper.getAttributeValue("myGauge"));
        EasyMock.verify((Object[])new Object[]{agent});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadConstructorCall() throws Throwable {
        new CollectionResourceWrapper(null, 1, "127.0.0.1", "HTTP", null, null, null, null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadderConstructorCall() throws Throwable {
        try {
            new CollectionResourceWrapper(null, -1, null, null, null, null, null, null, null, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void testGetCounterValue() throws Exception {
        SnmpCollectionAgent agent = this.createCollectionAgent();
        SnmpCollectionResource resource = this.createNodeResource(agent);
        String attributeName = "myCounter";
        String attributeId = "node[1].resourceType[node].instance[null].metric[" + attributeName + "]";
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        SnmpAttribute attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", "1000");
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        Date baseDate = new Date();
        CollectionResourceWrapper wrapper = this.createWrapper(resource, attributes, baseDate);
        Assert.assertFalse((boolean)CollectionResourceWrapper.s_cache.containsKey(attributeId));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)1000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", "2500");
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 300000L));
        Assert.assertEquals((Object)1000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", "5500");
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 600000L));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)10.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)5500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)10.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)5500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)10.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)5500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
    }

    @Test
    public void testGetCounterValueWithGap() throws Exception {
        this.m_ignoreWarnings = true;
        SnmpCollectionAgent agent = this.createCollectionAgent();
        SnmpCollectionResource resource = this.createNodeResource(agent);
        String attributeName = "myCounter";
        String attributeId = "node[1].resourceType[node].instance[null].metric[" + attributeName + "]";
        HashMap<String, Object> attributes = new HashMap<String, CollectionAttribute>();
        SnmpAttribute attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", "1000");
        attributes.put(attribute.getName(), attribute);
        Date baseDate = new Date();
        CollectionResourceWrapper wrapper = this.createWrapper(resource, attributes, baseDate);
        Assert.assertFalse((boolean)CollectionResourceWrapper.s_cache.containsKey(attributeId));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)1000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", "2500");
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 300000L));
        Assert.assertEquals((Object)1000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        attributes = new HashMap();
        attribute = this.addAttributeToCollectionResource(resource, "notMyCounter", AttributeType.COUNTER, "0", "1000");
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 600000L));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertNull((Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        attributes = new HashMap();
        attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", "7300");
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 900000L));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)8.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)7300.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)8.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)7300.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)8.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)7300.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        EasyMock.verify((Object[])new Object[]{agent});
    }

    @Test
    public void testGetCounterValueWithWrap() throws Exception {
        SnmpCollectionAgent agent = this.createCollectionAgent();
        SnmpCollectionResource resource = this.createNodeResource(agent);
        Date baseDate = new Date();
        String attributeName = "myCounter";
        String attributeId = "node[1].resourceType[node].instance[null].metric[" + attributeName + "]";
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        BigInteger initialValue = new BigDecimal(Math.pow(2.0, 32.0) - 20000.0).toBigInteger();
        SnmpAttribute attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", initialValue);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        CollectionResourceWrapper wrapper = this.createWrapper(resource, attributes, baseDate);
        Assert.assertFalse((boolean)CollectionResourceWrapper.s_cache.containsKey(attributeId));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)initialValue.doubleValue(), (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", new BigInteger("40000"));
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 300000L));
        Assert.assertEquals((Object)initialValue.doubleValue(), (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)200.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)40000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)200.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)40000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)200.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)40000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        EasyMock.verify((Object[])new Object[]{agent});
    }

    @Test
    public void testInterfaceResource() throws Exception {
        String ipAddress = "10.0.0.1";
        String ifName = "eth0";
        int ifIndex = 2;
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "testNode");
        network.addInterface(ipAddress);
        network.setIfAlias(ifName);
        network.setIfIndex(ifIndex);
        network.addService("ICMP");
        network.addService("SNMP");
        network.addService("HTTP");
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)db);
        SnmpCollectionAgent agent = this.createCollectionAgent();
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(agent.getNodeId()));
        node.setLabel("testNode");
        node.setForeignSource(agent.getForeignSource());
        node.setForeignId(agent.getForeignId());
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(node, ifIndex);
        snmpIface.setIfDescr(ifName);
        snmpIface.setIfName(ifName);
        snmpIface.setIfAlias(ifName);
        snmpIface.setIfSpeed(Long.valueOf(10000000L));
        snmpIface.setPhysAddr("001122334455");
        SnmpIfData ifData = new SnmpIfData(snmpIface);
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        IfResourceType resourceType = new IfResourceType(agent, collection);
        IfInfo resource = new IfInfo((org.opennms.netmgt.collectd.ResourceType)resourceType, (CollectionAgent)agent, ifData);
        SnmpAttribute attribute = this.addAttributeToCollectionResource((SnmpCollectionResource)resource, "ifInOctets", AttributeType.COUNTER, "ifIndex", "5000");
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        CollectionResourceWrapper wrapper = this.createWrapper((SnmpCollectionResource)resource, attributes);
        Assert.assertEquals((long)node.getId().intValue(), (long)wrapper.getNodeId());
        Assert.assertEquals((Object)"127.0.0.1", (Object)wrapper.getHostAddress());
        Assert.assertEquals((Object)"eth0-001122334455", (Object)wrapper.getIfLabel());
        Assert.assertEquals((Object)"if", (Object)wrapper.getResourceTypeName());
        Assert.assertEquals((Object)"SNMP", (Object)wrapper.getServiceName());
        Assert.assertEquals((Object)true, (Object)wrapper.isAnInterfaceResource());
        Assert.assertEquals((Object)Integer.toString(ifIndex), (Object)wrapper.getInstance());
        Assert.assertEquals((Object)Integer.toString(ifIndex), (Object)wrapper.getIfIndex());
        Assert.assertEquals((Object)Integer.toString(ifIndex), (Object)wrapper.getIfIndex());
        Assert.assertEquals((Object)Integer.toString(ifIndex), (Object)wrapper.getIfIndex());
        Assert.assertEquals((Object)"eth0", (Object)wrapper.getIfInfoValue("snmpifname"));
        Assert.assertEquals((Object)"eth0-001122334455", (Object)wrapper.getInstanceLabel());
        Assert.assertEquals((Object)"nodeSource[JUnit:T001].interfaceSnmp[eth0-001122334455]", (Object)wrapper.getResourceId().toString());
    }

    @Test
    public void testGenericResource() throws Exception {
        SnmpCollectionAgent agent = this.createCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        ResourceType rt = new ResourceType();
        rt.setName("hrStorageIndex");
        rt.setLabel("host-resources storage");
        StorageStrategy strategy = new StorageStrategy();
        strategy.setClazz("org.opennms.netmgt.dao.support.SiblingColumnStorageStrategy");
        strategy.addParameter((Parameter)new org.opennms.netmgt.config.datacollection.Parameter("sibling-column-name", "hrStorageLabel"));
        strategy.addParameter((Parameter)new org.opennms.netmgt.config.datacollection.Parameter("replace-all", "s/^-//"));
        rt.setStorageStrategy(strategy);
        PersistenceSelectorStrategy pstrategy = new PersistenceSelectorStrategy();
        pstrategy.setClazz("org.opennms.netmgt.collection.support.PersistAllSelectorStrategy");
        rt.setPersistenceSelectorStrategy(pstrategy);
        GenericIndexResourceType resourceType = new GenericIndexResourceType(agent, collection, rt);
        GenericIndexResource resource = new GenericIndexResource((org.opennms.netmgt.collectd.ResourceType)resourceType, resourceType.getName(), new SnmpInstId(100));
        SnmpAttribute used = this.addAttributeToCollectionResource((SnmpCollectionResource)resource, "hrStorageUsed", AttributeType.GAUGE, "hrStorageIndex", "5000");
        SnmpAttribute label = this.addAttributeToCollectionResource((SnmpCollectionResource)resource, "hrStorageLabel", AttributeType.STRING, "hrStorageIndex", "/opt");
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        attributes.put(used.getName(), (CollectionAttribute)used);
        attributes.put(label.getName(), (CollectionAttribute)label);
        CollectionResourceWrapper wrapper = this.createWrapper((SnmpCollectionResource)resource, attributes);
        Assert.assertEquals((Object)"opt", (Object)wrapper.getInstanceLabel());
    }

    @Test
    public void testNumericFields() throws Exception {
        SnmpCollectionAgent agent = this.createCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        ResourceType rt = new ResourceType();
        rt.setName("dskIndex");
        rt.setLabel("Disk Table Index (UCD-SNMP MIB)");
        StorageStrategy strategy = new StorageStrategy();
        strategy.setClazz("org.opennms.netmgt.dao.support.SiblingColumnStorageStrategy");
        strategy.addParameter((Parameter)new org.opennms.netmgt.config.datacollection.Parameter("sibling-column-name", "ns-dskPath"));
        strategy.addParameter((Parameter)new org.opennms.netmgt.config.datacollection.Parameter("replace-first", "s/^-$/_root_fs/"));
        strategy.addParameter((Parameter)new org.opennms.netmgt.config.datacollection.Parameter("replace-all", "s/^-//"));
        strategy.addParameter((Parameter)new org.opennms.netmgt.config.datacollection.Parameter("replace-all", "s/\\s//"));
        strategy.addParameter((Parameter)new org.opennms.netmgt.config.datacollection.Parameter("replace-all", "s/:\\\\.*//"));
        rt.setStorageStrategy(strategy);
        PersistenceSelectorStrategy pstrategy = new PersistenceSelectorStrategy();
        pstrategy.setClazz("org.opennms.netmgt.collection.support.PersistAllSelectorStrategy");
        rt.setPersistenceSelectorStrategy(pstrategy);
        GenericIndexResourceType resourceType = new GenericIndexResourceType(agent, collection, rt);
        GenericIndexResource resource = new GenericIndexResource((org.opennms.netmgt.collectd.ResourceType)resourceType, resourceType.getName(), new SnmpInstId(100));
        SnmpAttribute total = this.addAttributeToCollectionResource((SnmpCollectionResource)resource, "ns-dskTotal", AttributeType.GAUGE, "dskIndex", "10000");
        SnmpAttribute used = this.addAttributeToCollectionResource((SnmpCollectionResource)resource, "ns-dskUsed", AttributeType.GAUGE, "dskIndex", "5000");
        SnmpAttribute label = this.addAttributeToCollectionResource((SnmpCollectionResource)resource, "ns-dskPath", AttributeType.STRING, "dskIndex", "/opt");
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        attributes.put(used.getName(), (CollectionAttribute)used);
        attributes.put(total.getName(), (CollectionAttribute)total);
        attributes.put(label.getName(), (CollectionAttribute)label);
        CollectionResourceWrapper wrapper = this.createWrapper((SnmpCollectionResource)resource, attributes);
        Assert.assertEquals((Object)"opt", (Object)wrapper.getInstanceLabel());
        Assert.assertEquals((Object)new Double("10000.0"), (Object)wrapper.getAttributeValue(total.getName()));
        Assert.assertEquals((Object)"10000.0", (Object)wrapper.getFieldValue(total.getName()));
    }

    @Test
    public void testCounterReset_NMS7106() throws Exception {
        SnmpCollectionAgent agent = this.createCollectionAgent();
        SnmpCollectionResource resource = this.createNodeResource(agent);
        Date baseDate = new Date();
        System.err.println("------------------------");
        String attributeName = "myCounter";
        String attributeId = "node[1].resourceType[node].instance[null].metric[" + attributeName + "]";
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        BigInteger initialValue = new BigInteger("300");
        SnmpAttribute attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", initialValue);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        CollectionResourceWrapper wrapper = this.createWrapper(resource, attributes, baseDate);
        Assert.assertFalse((boolean)CollectionResourceWrapper.s_cache.containsKey(attributeId));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)initialValue.doubleValue(), (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertTrue((boolean)wrapper.getAttributeValue(attributeName).isNaN());
        attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", new BigInteger("600"));
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 300000L));
        Assert.assertFalse((boolean)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue().isNaN());
        Assert.assertEquals((Object)300.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)1.0, (Object)wrapper.getAttributeValue(attributeName));
        attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", new BigInteger("900"));
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 600000L));
        Assert.assertFalse((boolean)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue().isNaN());
        Assert.assertEquals((Object)600.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get(attributeId)).getValue());
        Assert.assertEquals((Object)1.0, (Object)wrapper.getAttributeValue(attributeName));
        attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", new BigInteger("60"));
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 900000L));
        wrapper.setCounterReset(true);
        Assert.assertTrue((boolean)wrapper.getAttributeValue(attributeName).isNaN());
        attribute = this.addAttributeToCollectionResource(resource, attributeName, AttributeType.COUNTER, "0", new BigInteger("120"));
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 1200000L));
        Assert.assertEquals((Object)0.2, (Object)wrapper.getAttributeValue(attributeName));
        EasyMock.verify((Object[])new Object[]{agent});
    }

    private SnmpCollectionResource createNodeResource(SnmpCollectionAgent agent) {
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig, this.m_locationAwareSnmpClient);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        return new NodeInfo(resourceType, (CollectionAgent)agent);
    }

    private CollectionResourceWrapper createWrapper(SnmpCollectionResource resource, Map<String, CollectionAttribute> attributes, Date timestamp) {
        CollectionResourceWrapper wrapper = new CollectionResourceWrapper(timestamp, 1, "127.0.0.1", "SNMP", this.getRepository(), (CollectionResource)resource, attributes, this.getResourceStorageDao(), this.m_ifLabelDao, null);
        return wrapper;
    }

    private CollectionResourceWrapper createWrapper(SnmpCollectionResource resource, Map<String, CollectionAttribute> attributes) {
        return this.createWrapper(resource, attributes, new Date());
    }

    private SnmpCollectionAgent createCollectionAgent() {
        SnmpCollectionAgent agent = (SnmpCollectionAgent)EasyMock.createMock(SnmpCollectionAgent.class);
        EasyMock.expect((Object)agent.getNodeId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)agent.getHostAddress()).andReturn((Object)"127.0.0.1").anyTimes();
        EasyMock.expect((Object)agent.getSnmpInterfaceInfo((IfResourceType)EasyMock.anyObject())).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)agent.getForeignSource()).andReturn((Object)"JUnit").anyTimes();
        EasyMock.expect((Object)agent.getForeignId()).andReturn((Object)"T001").anyTimes();
        EasyMock.expect((Object)agent.getStorageResourcePath()).andReturn((Object)ResourcePath.get((String[])new String[]{"fs", "JUnit", "T001"})).anyTimes();
        EasyMock.replay((Object[])new Object[]{agent});
        return agent;
    }

    private SnmpAttribute addAttributeToCollectionResource(SnmpCollectionResource resource, String attributeName, AttributeType attributeType, String attributeInstance, String value) {
        MibObject object = this.createMibObject(attributeType, attributeName, attributeInstance);
        Object objectType = null;
        SnmpValue snmpValue = null;
        if (AttributeType.STRING.equals((Object)attributeType)) {
            objectType = new SnmpAttributeType(resource.getResourceType(), "default", object, new AttributeGroupType("mibGroup", "ignore")){

                public AttributeType getType() {
                    return AttributeType.STRING;
                }

                public void storeAttribute(CollectionAttribute attribute, Persister persister) {
                    persister.persistStringAttribute(attribute);
                }
            };
            snmpValue = SnmpUtils.getValueFactory().getOctetString(value.getBytes());
        } else {
            objectType = new NumericAttributeType(resource.getResourceType(), "default", object, new AttributeGroupType("mibGroup", "ignore"));
            long v = Long.parseLong(value);
            snmpValue = AttributeType.COUNTER.equals((Object)attributeType) ? SnmpUtils.getValueFactory().getCounter32(v) : SnmpUtils.getValueFactory().getGauge32(v);
        }
        resource.setAttributeValue((SnmpAttributeType)objectType, snmpValue);
        return new SnmpAttribute((CollectionResource)resource, (SnmpAttributeType)objectType, snmpValue);
    }

    private SnmpAttribute addAttributeToCollectionResource(SnmpCollectionResource resource, String attributeName, AttributeType attributeType, String attributeInstance, BigInteger value) {
        MibObject object = this.createMibObject(attributeType, attributeName, attributeInstance);
        NumericAttributeType objectType = new NumericAttributeType(resource.getResourceType(), "default", object, new AttributeGroupType("mibGroup", "ignore"));
        SnmpValue snmpValue = SnmpUtils.getValueFactory().getCounter64(value);
        resource.setAttributeValue((SnmpAttributeType)objectType, snmpValue);
        return new SnmpAttribute((CollectionResource)resource, (SnmpAttributeType)objectType, snmpValue);
    }

    private MibObject createMibObject(AttributeType type, String alias, String instance) {
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias(alias);
        mibObject.setType(type.toString());
        mibObject.setInstance(instance);
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        return mibObject;
    }

    private RrdRepository getRepository() {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(this.tempFolder.getRoot());
        return repo;
    }

    private ResourceStorageDao getResourceStorageDao() {
        FilesystemResourceStorageDao resourceStorageDao = new FilesystemResourceStorageDao();
        resourceStorageDao.setRrdDirectory(this.tempFolder.getRoot());
        return resourceStorageDao;
    }
}

