/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.config.dao.thresholding.api.ReadableThreshdDao;
import org.opennms.netmgt.config.dao.thresholding.api.ReadableThresholdingDao;
import org.opennms.netmgt.config.poller.outages.Outage;
import org.opennms.netmgt.config.poller.outages.Outages;
import org.opennms.netmgt.config.threshd.FilterOperator;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.config.threshd.ThreshdConfiguration;
import org.opennms.netmgt.dao.api.IfLabel;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.DefaultThresholdsDao;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.threshd.api.ThresholdingSet;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdingSetImpl
implements ThresholdingSet {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdingSetImpl.class);
    protected final int m_nodeId;
    protected final String m_hostAddress;
    protected final String m_serviceName;
    protected final RrdRepository m_repository;
    protected ThresholdsDao m_thresholdsDao;
    protected ThresholdingEventProxy m_eventProxy;
    protected ResourceStorageDao m_resourceStorageDao;
    private boolean m_initialized = false;
    private boolean m_hasThresholds = false;
    private boolean m_counterReset = false;
    private ServiceParameters m_svcParams;
    protected final List<ThresholdGroup> m_thresholdGroups = new LinkedList<ThresholdGroup>();
    protected final List<String> m_scheduledOutages = new ArrayList<String>();
    private final ThresholdingSession m_thresholdingSession;
    private final ReadableThreshdDao m_threshdDao;
    private final ReadableThresholdingDao m_thresholdingDao;
    private final ReadablePollOutagesDao m_pollOutagesDao;
    private final IfLabel m_ifLabelDao;

    public ThresholdingSetImpl(int nodeId, String hostAddress, String serviceName, RrdRepository repository, ServiceParameters svcParams, ResourceStorageDao resourceStorageDao, ThresholdingEventProxy eventProxy, ThresholdingSession thresholdingSession, ReadableThreshdDao threshdDao, ReadableThresholdingDao thresholdingDao, ReadablePollOutagesDao pollOutagesDao, IfLabel ifLabelDao) throws ThresholdInitializationException {
        this.m_nodeId = nodeId;
        this.m_hostAddress = hostAddress == null ? null : hostAddress.intern();
        this.m_serviceName = serviceName == null ? null : serviceName.intern();
        this.m_repository = repository;
        this.m_svcParams = svcParams;
        this.m_resourceStorageDao = resourceStorageDao;
        this.m_eventProxy = eventProxy;
        this.m_thresholdingSession = Objects.requireNonNull(thresholdingSession);
        this.m_threshdDao = Objects.requireNonNull(threshdDao);
        this.m_thresholdingDao = Objects.requireNonNull(thresholdingDao);
        this.m_pollOutagesDao = Objects.requireNonNull(pollOutagesDao);
        this.m_ifLabelDao = Objects.requireNonNull(ifLabelDao);
        this.initThresholdsDao();
        this.initialize();
        if (!this.m_initialized) {
            throw new ThresholdInitializationException("Failed to initialize thresholding set.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws ThresholdInitializationException {
        String logHeader = "initialize(nodeId=" + this.m_nodeId + ",ipAddr=" + this.m_hostAddress + ",svc=" + this.m_serviceName + ")";
        List<String> groupNameList = this.getThresholdGroupNames(this.m_nodeId, this.m_hostAddress, this.m_serviceName);
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            this.m_thresholdGroups.clear();
            for (String groupName : groupNameList) {
                try {
                    ThresholdGroup thresholdGroup = this.m_thresholdsDao.get(groupName, this.m_thresholdingSession);
                    if (thresholdGroup == null) {
                        LOG.error("{}: Could not get threshold group with name {}", (Object)logHeader, (Object)groupName);
                        continue;
                    }
                    this.m_thresholdGroups.add(thresholdGroup);
                    LOG.debug("{}: Adding threshold group: {}", (Object)logHeader, (Object)thresholdGroup);
                }
                catch (Throwable e) {
                    LOG.error("{}: Can't process threshold group {}", new Object[]{logHeader, groupName, e});
                }
            }
            this.m_hasThresholds = !this.m_thresholdGroups.isEmpty();
        }
        this.updateScheduledOutages();
    }

    public void reinitialize() {
        this.m_initialized = false;
        boolean hasThresholds = this.m_hasThresholds;
        ArrayList<ThresholdGroup> thresholdGroups = new ArrayList<ThresholdGroup>(this.m_thresholdGroups);
        ArrayList<String> scheduledOutages = new ArrayList<String>(this.m_scheduledOutages);
        try {
            this.initThresholdsDao();
            this.mergeThresholdGroups(this.m_nodeId, this.m_hostAddress, this.m_serviceName);
            this.updateScheduledOutages();
        }
        catch (Exception e) {
            LOG.error("Failed to reinitialize thresholding set.  Reverting to previous configuration.", (Throwable)e);
            this.m_hasThresholds = hasThresholds;
            if (!thresholdGroups.equals(this.m_thresholdGroups)) {
                this.m_thresholdGroups.clear();
                this.m_thresholdGroups.addAll(thresholdGroups);
            }
            if (!scheduledOutages.equals(this.m_scheduledOutages)) {
                this.m_scheduledOutages.clear();
                this.m_scheduledOutages.addAll(scheduledOutages);
            }
            this.m_initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeThresholdGroups(int nodeId, String hostAddress, String serviceName) throws ThresholdInitializationException {
        String logHeader = "mergeThresholdGroups(nodeId=" + nodeId + ",ipAddr=" + hostAddress + ",svc=" + serviceName + ")";
        LOG.debug("{}: Begin merging operation", (Object)logHeader);
        List existingGroupNameList = this.m_thresholdGroups.stream().map(ThresholdGroup::getName).collect(Collectors.toList());
        List<String> newGroupNameList = this.getThresholdGroupNames(nodeId, hostAddress, serviceName);
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            if (newGroupNameList.size() != this.m_thresholdGroups.size() || !existingGroupNameList.equals(newGroupNameList)) {
                LOG.debug("{}: New group name list differs from current threshold group list", (Object)logHeader);
                Iterator<ThresholdGroup> i = this.m_thresholdGroups.iterator();
                while (i.hasNext()) {
                    ThresholdGroup group = i.next();
                    if (newGroupNameList.contains(group.getName())) continue;
                    LOG.info("{}: deleting group {}", (Object)logHeader, (Object)group);
                    group.delete();
                    i.remove();
                }
            }
            LinkedList<ThresholdGroup> newThresholdGroupList = new LinkedList<ThresholdGroup>();
            for (String groupName : newGroupNameList) {
                Optional<ThresholdGroup> foundGroup = this.m_thresholdGroups.stream().filter(tg -> groupName.equals(tg.getName())).findFirst();
                try {
                    ThresholdGroup thresholdGroup;
                    if (!foundGroup.isPresent()) {
                        thresholdGroup = this.m_thresholdsDao.get(groupName, this.m_thresholdingSession);
                        if (thresholdGroup == null) {
                            LOG.error("{}: Could not get threshold group with name {}", (Object)logHeader, (Object)groupName);
                            continue;
                        }
                        newThresholdGroupList.add(thresholdGroup);
                        LOG.debug("{}: Adding threshold group: {}", (Object)logHeader, (Object)thresholdGroup);
                        continue;
                    }
                    thresholdGroup = this.m_thresholdsDao.merge(foundGroup.get(), this.m_thresholdingSession);
                    newThresholdGroupList.add(thresholdGroup);
                    LOG.debug("{}: Merging threshold group: {}", (Object)logHeader, (Object)thresholdGroup);
                }
                catch (IllegalStateException e) {
                    ThresholdInitializationException tie = new ThresholdInitializationException("Unable to add or merge existing group " + foundGroup.orElse(null), (Throwable)e);
                    LOG.error(tie.getLocalizedMessage(), (Throwable)e);
                    throw tie;
                }
            }
            this.m_thresholdGroups.clear();
            this.m_thresholdGroups.addAll(newThresholdGroupList);
            this.m_hasThresholds = !this.m_thresholdGroups.isEmpty();
        }
    }

    public boolean hasThresholds() {
        return this.m_hasThresholds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasThresholds(String resourceTypeName, String attributeName) {
        boolean ok = false;
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            for (ThresholdGroup group : this.m_thresholdGroups) {
                Map<String, Set<ThresholdEntity>> entityMap = ThresholdingSetImpl.getEntityMap(group, resourceTypeName);
                if (entityMap == null) continue;
                for (Map.Entry<String, Set<ThresholdEntity>> entry : entityMap.entrySet()) {
                    Set<ThresholdEntity> value = entry.getValue();
                    for (ThresholdEntity thresholdEntity : value) {
                        Collection<String> requiredDatasources = thresholdEntity.getRequiredDatasources();
                        if (requiredDatasources.contains(attributeName)) {
                            ok = true;
                            LOG.debug("hasThresholds: {}@{}? {}", new Object[]{resourceTypeName, attributeName, ok});
                            continue;
                        }
                        LOG.trace("hasThresholds: {}@{}? {}", new Object[]{resourceTypeName, attributeName, ok});
                    }
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isNodeInOutage() {
        boolean outageFound = false;
        List<String> list = this.m_scheduledOutages;
        synchronized (list) {
            for (String outageName : this.m_scheduledOutages) {
                if (!this.m_pollOutagesDao.isCurTimeInOutage(outageName)) continue;
                LOG.debug("isNodeInOutage[node={}]: current time is on outage using '{}'; checking the node with IP {}", new Object[]{this.m_nodeId, outageName, this.m_hostAddress});
                if (!this.m_pollOutagesDao.isNodeIdInOutage((long)this.m_nodeId, outageName) && !this.m_pollOutagesDao.isInterfaceInOutage(this.m_hostAddress, outageName)) continue;
                LOG.debug("isNodeInOutage[node={}]: configured outage '{}' applies, interface {} will be ignored for threshold processing", new Object[]{this.m_nodeId, outageName, this.m_hostAddress});
                outageFound = true;
                break;
            }
        }
        return outageFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<Event> applyThresholds(CollectionResourceWrapper resourceWrapper, Map<String, CollectionAttribute> attributesMap) {
        LinkedList<Event> eventsList = new LinkedList<Event>();
        if (attributesMap == null || attributesMap.size() == 0) {
            LOG.debug("applyThresholds: Ignoring resource {} because required attributes map is empty.", (Object)resourceWrapper);
            return eventsList;
        }
        LOG.debug("applyThresholds: Applying thresholds on {} using {} attributes.", (Object)resourceWrapper, (Object)attributesMap.size());
        Date date = new Date();
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            for (ThresholdGroup group : this.m_thresholdGroups) {
                Map<String, Set<ThresholdEntity>> entityMap = ThresholdingSetImpl.getEntityMap(group, resourceWrapper.getResourceTypeName());
                if (entityMap == null) continue;
                for (Map.Entry<String, Set<ThresholdEntity>> entry : entityMap.entrySet()) {
                    String key = entry.getKey();
                    Set<ThresholdEntity> value = entry.getValue();
                    for (ThresholdEntity thresholdEntity : value) {
                        if (this.passedThresholdFilters(resourceWrapper, thresholdEntity)) {
                            LOG.info("applyThresholds: Processing threshold {} : {} on resource {}", new Object[]{key, thresholdEntity, resourceWrapper});
                            Collection<String> requiredDatasources = thresholdEntity.getThresholdConfig().getRequiredDatasources();
                            HashMap<String, Double> values = new HashMap<String, Double>();
                            boolean valueMissing = false;
                            boolean relaxed = thresholdEntity.getThresholdConfig().getBasethresholddef().getRelaxed();
                            for (String ds : requiredDatasources) {
                                Double dsValue = resourceWrapper.getAttributeValue(ds);
                                if (dsValue == null) {
                                    LOG.info("applyThresholds: Could not get data source value for '{}', {}", (Object)ds, (Object)(relaxed ? "but the expression will be evaluated (relaxed mode enabled)" : "not evaluating threshold"));
                                    valueMissing = true;
                                }
                                values.put(ds, dsValue);
                            }
                            if (valueMissing && !relaxed) continue;
                            LOG.info("applyThresholds: All attributes found for {}, evaluating", (Object)resourceWrapper);
                            resourceWrapper.setDsLabel(thresholdEntity.getDatasourceLabel());
                            try {
                                List<Event> thresholdEvents = thresholdEntity.evaluateAndCreateEvents(resourceWrapper, values, date);
                                eventsList.addAll(thresholdEvents);
                            }
                            catch (Exception e) {
                                LOG.warn("applyThresholds: Can't evaluate {} on {} because {}", new Object[]{key, resourceWrapper, e.getMessage()});
                            }
                            continue;
                        }
                        LOG.info("applyThresholds: Not processing threshold {} : {} because no filters matched", (Object)key, (Object)thresholdEntity);
                    }
                }
            }
        }
        return eventsList;
    }

    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        if (resource.isAnInterfaceResource() && !resource.isValidInterfaceResource()) {
            LOG.info("passedThresholdFilters: Could not get data interface information for '{}' or this interface has an invalid ifIndex.  Not evaluating threshold.", (Object)resource.getIfLabel());
            return false;
        }
        List filters = thresholdEntity.getThresholdConfig().getBasethresholddef().getResourceFilters();
        if (filters.size() == 0) {
            return true;
        }
        LOG.debug("passedThresholdFilters: applying {} filters to resource {}", (Object)filters.size(), (Object)resource);
        int count = 1;
        FilterOperator operator = thresholdEntity.getThresholdConfig().getBasethresholddef().getFilterOperator();
        boolean andResult = true;
        for (ResourceFilter f : filters) {
            LOG.debug("passedThresholdFilters: filter #{}: field={}, regex='{}'", new Object[]{count, f.getField(), f.getContent().orElse(null)});
            ++count;
            String attr = resource.getFieldValue(f.getField());
            if (attr != null) {
                try {
                    Pattern p = Pattern.compile(f.getContent().orElse(""));
                    Matcher m = p.matcher(attr);
                    boolean pass = m.matches();
                    LOG.debug("passedThresholdFilters: the value of {} is {}. Pass filter? {}", new Object[]{f.getField(), attr, pass});
                    if (operator.equals((Object)FilterOperator.OR) && pass) {
                        return true;
                    }
                    if (!operator.equals((Object)FilterOperator.AND) || (andResult = andResult && pass)) continue;
                    return false;
                }
                catch (PatternSyntaxException e) {
                    LOG.warn("passedThresholdFilters: the regular expression {} is invalid: {}", new Object[]{f.getContent().orElse(null), e.getMessage(), e});
                    return false;
                }
            }
            LOG.warn("passedThresholdFilters: can't find value of {} for resource {}", (Object)f.getField(), (Object)resource);
            if (!operator.equals((Object)FilterOperator.AND)) continue;
            return false;
        }
        return operator.equals((Object)FilterOperator.AND) && andResult;
    }

    protected final void initThresholdsDao() throws ThresholdInitializationException {
        if (!this.m_initialized) {
            LOG.debug("initThresholdsDao: Initializing Factories and DAOs");
            DefaultThresholdsDao defaultThresholdsDao = new DefaultThresholdsDao();
            try {
                this.m_thresholdingDao.reload();
                defaultThresholdsDao.setThresholdingDao(this.m_thresholdingDao);
                defaultThresholdsDao.setEventProxy(this.m_eventProxy);
                defaultThresholdsDao.afterPropertiesSet();
            }
            catch (Throwable t) {
                ThresholdInitializationException tie = new ThresholdInitializationException("Could not initialize DefaultThresholdsDao.", t);
                LOG.error("initThresholdsDao: " + tie.getLocalizedMessage(), t);
                throw tie;
            }
            try {
                this.m_threshdDao.reload();
            }
            catch (Throwable t) {
                ThresholdInitializationException tie = new ThresholdInitializationException("Could not initialize ThreshdConfigFactory.", t);
                LOG.error("initThresholdsDao: " + tie.getLocalizedMessage(), t);
                throw tie;
            }
            this.m_thresholdsDao = defaultThresholdsDao;
            this.m_initialized = true;
        }
    }

    private final List<String> getThresholdGroupNames(int nodeId, String hostAddress, String serviceName) {
        LinkedList<String> groupNameList = new LinkedList<String>();
        for (Package pkg : ((ThreshdConfiguration)this.m_threshdDao.getConfig()).getPackages()) {
            if (!ReadableThreshdDao.serviceInPackageAndEnabled((String)serviceName, (Package)pkg)) {
                LOG.debug("getThresholdGroupNames: address/service: {}/{} not scheduled, service is not enabled or does not exist in package: {}", new Object[]{hostAddress, serviceName, pkg.getName()});
                continue;
            }
            LOG.debug("getThresholdGroupNames: checking ipaddress {} for inclusion in pkg {}", (Object)hostAddress, (Object)pkg.getName());
            if (!this.m_threshdDao.interfaceInPackage(hostAddress, pkg)) {
                LOG.debug("getThresholdGroupNames: address/service: {}/{} not scheduled, interface does not belong to package: {}", new Object[]{hostAddress, serviceName, pkg.getName()});
                continue;
            }
            for (Service svc : pkg.getServices()) {
                if (!svc.getName().equals(serviceName)) continue;
                for (Parameter parameter : svc.getParameters()) {
                    if (!parameter.getKey().equals("thresholding-group")) continue;
                    String groupName = parameter.getValue();
                    groupNameList.add(groupName);
                    LOG.debug("getThresholdGroupNames:  address/service: {}/{}. Adding Group {}", new Object[]{hostAddress, serviceName, groupName});
                }
            }
        }
        return groupNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateScheduledOutages() {
        List<String> list = this.m_scheduledOutages;
        synchronized (list) {
            this.m_scheduledOutages.clear();
            for (Package pkg : ((ThreshdConfiguration)this.m_threshdDao.getConfig()).getPackages()) {
                for (String outageCal : pkg.getOutageCalendars()) {
                    LOG.info("updateScheduledOutages[node={}]: checking scheduled outage '{}'", (Object)this.m_nodeId, (Object)outageCal);
                    try {
                        Outage outage = ((Outages)this.m_pollOutagesDao.getConfig()).getOutage(outageCal);
                        if (outage == null) {
                            LOG.info("updateScheduledOutages[node={}]: scheduled outage '{}' is not defined.", (Object)this.m_nodeId, (Object)outageCal);
                            continue;
                        }
                        LOG.debug("updateScheduledOutages[node={}]: outage calendar '{}' found on package '{}'", new Object[]{this.m_nodeId, outage.getName(), pkg.getName()});
                        this.m_scheduledOutages.add(outageCal);
                    }
                    catch (Exception e) {
                        LOG.info("updateScheduledOutages[node={}]: scheduled outage '{}' does not exist.", (Object)this.m_nodeId, (Object)outageCal);
                    }
                }
            }
        }
    }

    private static Map<String, Set<ThresholdEntity>> getEntityMap(ThresholdGroup thresholdGroup, String resourceType) {
        LOG.trace("getEntityMap: checking if the resourceType '{}' exists on threshold group {}", (Object)resourceType, (Object)thresholdGroup);
        Map<String, Set<ThresholdEntity>> entityMap = null;
        if ("node".equals(resourceType)) {
            entityMap = thresholdGroup.getNodeResourceType().getThresholdMap();
        } else if ("if".equals(resourceType) || "latency".equals(resourceType)) {
            entityMap = thresholdGroup.getIfResourceType().getThresholdMap();
        } else {
            Map<String, ThresholdResourceType> typeMap = thresholdGroup.getGenericResourceTypeMap();
            if (typeMap == null) {
                LOG.error("getEntityMap: Generic Resource Type map was null (this shouldn't happen) for threshold group {}", (Object)thresholdGroup.getName());
                return null;
            }
            ThresholdResourceType thisResourceType = typeMap.get(resourceType);
            if (thisResourceType == null) {
                LOG.debug("getEntityMap: No thresholds configured for resource type '{}' in threshold group {}. Skipping this group.", (Object)resourceType, (Object)thresholdGroup.getName());
                return null;
            }
            entityMap = thisResourceType.getThresholdMap();
        }
        return Collections.unmodifiableMap(entityMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<ThresholdGroup> list = this.m_thresholdGroups;
        synchronized (list) {
            return this.m_thresholdGroups.toString();
        }
    }

    public void setCounterReset(boolean counterReset) {
        this.m_counterReset = counterReset;
    }

    public boolean hasThresholds(CollectionAttribute attribute) {
        CollectionResource resource = attribute.getResource();
        if (attribute == null || resource == null) {
            return false;
        }
        if (!this.isCollectionEnabled(resource)) {
            return false;
        }
        if (resource instanceof AliasedResource && !this.storeByIfAlias()) {
            return false;
        }
        return this.hasThresholds(resource.getResourceTypeName(), attribute.getName());
    }

    public List<Event> applyThresholds(CollectionResource resource, Map<String, CollectionAttribute> attributesMap, Date collectionTimestamp) {
        if (!this.isCollectionEnabled(resource)) {
            LOG.debug("applyThresholds: Ignoring resource {} because data collection is disabled for this resource.", (Object)resource);
            return new LinkedList<Event>();
        }
        CollectionResourceWrapper resourceWrapper = new CollectionResourceWrapper(collectionTimestamp, this.m_nodeId, this.m_hostAddress, this.m_serviceName, this.m_repository, resource, attributesMap, this.m_resourceStorageDao, this.m_ifLabelDao);
        resourceWrapper.setCounterReset(this.m_counterReset);
        return Collections.unmodifiableList(this.applyThresholds(resourceWrapper, attributesMap));
    }

    public List<ThresholdGroup> getThresholdGroups() {
        return this.m_thresholdGroups;
    }

    private boolean isCollectionEnabled(CollectionResource resource) {
        return resource.shouldPersist(this.m_svcParams);
    }

    private boolean storeByIfAlias() {
        String storeByIfAliasString = this.m_svcParams.getStoreByIfAlias();
        return storeByIfAliasString != null && "true".equalsIgnoreCase(storeByIfAliasString);
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public List<String> getscheduledOutages() {
        return this.m_scheduledOutages;
    }
}

