/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import org.opennms.features.distributed.kvstore.api.BlobStore;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.ThresholdingServiceImpl;
import org.opennms.netmgt.threshd.ThresholdingVisitorImpl;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.threshd.api.ThresholdingSessionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdingSessionImpl
implements ThresholdingSession {
    protected static final Logger LOG = LoggerFactory.getLogger(ThresholdingSessionImpl.class);
    protected final ThresholdingServiceImpl service;
    protected final ThresholdingSessionKey sessionKey;
    protected final ResourceStorageDao resourceStorageDao;
    protected final RrdRepository rrdRepository;
    private ServiceParameters serviceParameters;
    private final BlobStore blobStore;
    private final boolean isDistributed;

    public ThresholdingSessionImpl(ThresholdingServiceImpl service, ThresholdingSessionKey sessionKey, ResourceStorageDao resourceStorageDao, RrdRepository rrdRepository, ServiceParameters serviceParams, BlobStore blobStore, boolean isDistributed) {
        this.service = service;
        this.sessionKey = sessionKey;
        this.resourceStorageDao = resourceStorageDao;
        this.rrdRepository = rrdRepository;
        this.serviceParameters = serviceParams;
        this.blobStore = blobStore;
        this.isDistributed = isDistributed;
    }

    public void accept(CollectionSet collectionSet) throws ThresholdInitializationException {
        this.acceptCollection(collectionSet);
    }

    public void close() throws Exception {
        this.service.close(this);
    }

    public ThresholdingSessionKey getKey() {
        return this.sessionKey;
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    public ResourceStorageDao getResourceDao() {
        return this.resourceStorageDao;
    }

    public RrdRepository getRrdRepository() {
        return this.rrdRepository;
    }

    public ServiceParameters getServiceParameters() {
        return this.serviceParameters;
    }

    private void acceptCollection(CollectionSet collectionSet) throws ThresholdInitializationException {
        ThresholdingVisitorImpl thresholdingVisitor = this.service.getThresholdingVistor(this);
        if (thresholdingVisitor == null) {
            LOG.error("No thresholdingVisitor for ThresholdingSession {}", (Object)this.sessionKey);
            return;
        }
        if (thresholdingVisitor.isNodeInOutage()) {
            LOG.info("run: the threshold processing will be skipped because the node {} is on a scheduled outage.", (Object)thresholdingVisitor.getNodeId());
        } else if (thresholdingVisitor.hasThresholds()) {
            thresholdingVisitor.setCounterReset(collectionSet.ignorePersist());
            collectionSet.visit((CollectionSetVisitor)thresholdingVisitor);
        }
    }

    public boolean isDistributed() {
        return this.isDistributed;
    }
}

