/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opennms.features.distributed.kvstore.api.BlobStore;
import org.opennms.features.distributed.kvstore.blob.inmemory.InMemoryMapBlobStore;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.MockSession;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluatorHighLow;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.api.ThresholdingSession;

public class ThresholdStateTest {
    private final BlobStore blobStore = new InMemoryMapBlobStore(System::currentTimeMillis);

    @Test
    public void canResumeWithState() {
        ThresholdingSession thresholdingSession = MockSession.getSession();
        Mockito.when((Object)thresholdingSession.getBlobStore()).thenReturn((Object)this.blobStore);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)this.getWrapper(), MockSession.getSession());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
        item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)this.getWrapper(), MockSession.getSession());
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"second threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
    }

    private ThresholdConfigWrapper getWrapper() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(2));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        return wrapper;
    }
}

