/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorTestCase;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.MockCollectionResourceWrapper;
import org.opennms.netmgt.threshd.MockSession;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluatorHighLow;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.ThrowableAnticipator;

public class ThresholdEvaluatorHighLowTest
extends AbstractThresholdEvaluatorTestCase {
    @Test
    public void testConstructorThresholdNull() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new NullPointerException());
        try {
            new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow(null, MockSession.getSession());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testConstructorThresholdNoType() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("threshold must have a 'type' value set"));
        Threshold threshold = new Threshold();
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        try {
            new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testConstructorThresholdNoDsName() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("threshold must have a 'ds-name' value set"));
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        try {
            new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testConstructorThresholdNoDsType() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("threshold must have a 'ds-type' value set"));
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setValue(Double.valueOf(1.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        try {
            new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testConstructorThresholdNoValue() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("threshold must have a 'value' value set"));
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        try {
            new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testConstructorThresholdNoRearm() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("threshold must have a 'rearm' value set"));
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.0));
        threshold.setTrigger(Integer.valueOf(3));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        try {
            new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testConstructorThresholdNoTrigger() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("threshold must have a 'trigger' value set"));
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(1.0));
        threshold.setRearm(Double.valueOf(0.5));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        try {
            new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testEvaluateHighNoTrigger() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(101.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
    }

    @Test
    public void testEvaluateHighTriggerOnce() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
    }

    @Test
    public void testEvaluateHighNoTriggerTwice() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(2));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
    }

    @Test
    public void testEvaluateHighTriggerTwice() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(2));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"second threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
    }

    @Test
    public void testEvaluateHighTriggerTwiceNoRetrigger() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(2));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"second threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"third threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"fourth threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
    }

    @Test
    public void testEvaluateHighTriggerRearm() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
        status = item.evaluate(0.0);
        Assert.assertEquals((String)"second threshold evaluation status", (Object)ThresholdEvaluatorState.Status.RE_ARMED, (Object)status);
    }

    @Test
    public void testEvaluateHighTriggerRearmTriggerAgain() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
        status = item.evaluate(0.0);
        Assert.assertEquals((String)"second threshold evaluation status", (Object)ThresholdEvaluatorState.Status.RE_ARMED, (Object)status);
        status = item.evaluate(100.0);
        Assert.assertEquals((String)"third threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
    }

    @Test
    public void testEvaluateLowTriggerOnce() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.LOW);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
    }

    @Test
    public void testIsThresholdExceededHighTriggeredAbove() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertTrue((String)"threshold should be exceeded", (boolean)item.isThresholdExceeded(100.0));
    }

    @Test
    public void testIsThresholdExceededHighTriggeredEqual() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertTrue((String)"threshold should be exceeded", (boolean)item.isThresholdExceeded(99.0));
    }

    @Test
    public void testIsThresholdExceededHighNotTriggeredBelow() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertFalse((String)"threshold should not be exceeded", (boolean)item.isThresholdExceeded(98.0));
    }

    @Test
    public void testIsThresholdExceededLowTriggeredBelow() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.LOW);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertTrue((String)"threshold should be exceeded", (boolean)item.isThresholdExceeded(98.0));
    }

    @Test
    public void testIsThresholdExceededLowTriggeredEqual() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.LOW);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertTrue((String)"threshold should be exceeded", (boolean)item.isThresholdExceeded(99.0));
    }

    @Test
    public void testIsThresholdExceededLowNotTriggeredAbove() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.LOW);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertFalse((String)"threshold should not be exceeded", (boolean)item.isThresholdExceeded(100.0));
    }

    @Test
    public void testIsThresholdExceededBogusType() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("This thresholding strategy can only be used for thresholding types of 'high' and 'low'."));
        try {
            ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
            item.isThresholdExceeded(98.0);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testIsRearmExceededHighTriggeredBelow() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertTrue((String)"rearm should be exceeded", (boolean)item.isRearmExceeded(0.0));
    }

    @Test
    public void testIsRearmExceededHighTriggeredEqual() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertTrue((String)"rearm should be exceeded", (boolean)item.isRearmExceeded(0.5));
    }

    @Test
    public void testIsRearmExceededHighNoTriggeredAbove() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertFalse((String)"rearm should not be exceeded", (boolean)item.isRearmExceeded(1.0));
    }

    @Test
    public void testIsRearmExceededLowTriggeredAbove() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.LOW);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertTrue((String)"rearm should be exceeded", (boolean)item.isRearmExceeded(1.0));
    }

    @Test
    public void testIsRearmExceededLowTriggeredEqual() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.LOW);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertTrue((String)"rearm should be exceeded", (boolean)item.isRearmExceeded(0.5));
    }

    @Test
    public void testIsRearmExceededLowNoTriggeredBelow() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.LOW);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertFalse((String)"rearm should not be exceeded", (boolean)item.isRearmExceeded(0.0));
    }

    @Test
    public void testIsRearmExceededBogusType() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.RELATIVE_CHANGE);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("This thresholding strategy can only be used for thresholding types of 'high' and 'low'."));
        try {
            ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
            item.isThresholdExceeded(0.0);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testIsTriggerCountExceededAtTriggerValueOne() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertFalse((String)"trigger count should not be exeeded before exceeding value", (boolean)item.isTriggerCountExceeded());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
        Assert.assertTrue((String)"trigger count should be exeeded after exceeding value (and being triggered)", (boolean)item.isTriggerCountExceeded());
    }

    @Test
    public void testIsTriggerCountExceededNotAtTriggerValueTwo() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(2));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertFalse((String)"trigger count should not be exeeded before exceeding value", (boolean)item.isTriggerCountExceeded());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)status);
        Assert.assertFalse((String)"trigger count should not be exeeded after only exceeding value once", (boolean)item.isTriggerCountExceeded());
    }

    @Test
    public void testIsTriggerCountExceededNotAfterReArm() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(0.5));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Assert.assertFalse((String)"trigger count should not be exeeded before exceeding value", (boolean)item.isTriggerCountExceeded());
        ThresholdEvaluatorState.Status status = item.evaluate(100.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)status);
        Assert.assertTrue((String)"trigger count should  be exeeded after exceeding value", (boolean)item.isTriggerCountExceeded());
        status = item.evaluate(0.0);
        Assert.assertEquals((String)"first threshold evaluation status", (Object)ThresholdEvaluatorState.Status.RE_ARMED, (Object)status);
        Assert.assertFalse((String)"trigger count should be reset after being rearmed", (boolean)item.isTriggerCountExceeded());
    }

    @Test
    public void testGetEventForStateDefaultUEIS() {
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(95.0));
        threshold.setTrigger(Integer.valueOf(1));
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Event event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 100.0, null);
        Assert.assertEquals((String)"UEI should be the highThresholdExceededUEI", (Object)"uei.opennms.org/threshold/highThresholdExceeded", (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentAndValueNonNull(event, "instance");
        event = item.getEventForState(ThresholdEvaluatorState.Status.RE_ARMED, new Date(), 94.0, null);
        Assert.assertEquals((String)"UEI should be the highThresholdRearmedUEI", (Object)"uei.opennms.org/threshold/highThresholdRearmed", (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentAndValueNonNull(event, "instance");
        event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 100.0, (CollectionResourceWrapper)new MockCollectionResourceWrapper("testInstance"));
        Assert.assertEquals((String)"UEI should be the highThresholdExceededUEI", (Object)"uei.opennms.org/threshold/highThresholdExceeded", (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentWithValue(event, "instance", "testInstance");
        event = item.getEventForState(ThresholdEvaluatorState.Status.RE_ARMED, new Date(), 94.0, (CollectionResourceWrapper)new MockCollectionResourceWrapper("testInstance"));
        Assert.assertEquals((String)"UEI should be the highThresholdRearmedUEI", (Object)"uei.opennms.org/threshold/highThresholdRearmed", (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentWithValue(event, "instance", "testInstance");
        threshold.setType(ThresholdType.LOW);
        threshold.setValue(Double.valueOf(95.0));
        threshold.setRearm(Double.valueOf(99.0));
        event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 94.0, null);
        Assert.assertEquals((String)"UEI should be the lowThresholdExceededUEI", (Object)"uei.opennms.org/threshold/lowThresholdExceeded", (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentAndValueNonNull(event, "instance");
        event = item.getEventForState(ThresholdEvaluatorState.Status.RE_ARMED, new Date(), 100.0, null);
        Assert.assertEquals((String)"UEI should be the lowThresholdRearmedUEI", (Object)"uei.opennms.org/threshold/lowThresholdRearmed", (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentAndValueNonNull(event, "instance");
        event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 94.0, (CollectionResourceWrapper)new MockCollectionResourceWrapper("testInstance"));
        Assert.assertEquals((String)"UEI should be the lowThresholdExceededUEI", (Object)"uei.opennms.org/threshold/lowThresholdExceeded", (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentWithValue(event, "instance", "testInstance");
        event = item.getEventForState(ThresholdEvaluatorState.Status.RE_ARMED, new Date(), 100.0, (CollectionResourceWrapper)new MockCollectionResourceWrapper("testInstance"));
        Assert.assertEquals((String)"UEI should be the lowThresholdRearmedUEI", (Object)"uei.opennms.org/threshold/lowThresholdRearmed", (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentWithValue(event, "instance", "testInstance");
    }

    @Test
    public void testGetEventForStateCustomUEIS() {
        String triggeredUEI = "uei.opennms.org/custom/thresholdTriggered";
        String rearmedUEI = "uei.opennms.org/custom/thresholdRearmed";
        Threshold threshold = new Threshold();
        threshold.setType(ThresholdType.HIGH);
        threshold.setDsName("ds-name");
        threshold.setDsType("node");
        threshold.setValue(Double.valueOf(99.0));
        threshold.setRearm(Double.valueOf(95.0));
        threshold.setTrigger(Integer.valueOf(1));
        threshold.setTriggeredUEI(triggeredUEI);
        threshold.setRearmedUEI(rearmedUEI);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow item = new ThresholdEvaluatorHighLow.ThresholdEvaluatorStateHighLow((BaseThresholdDefConfigWrapper)wrapper, MockSession.getSession());
        Event event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 100.0, null);
        Assert.assertEquals((String)"UEI should be the uei.opennms.org/custom/thresholdTriggered", (Object)triggeredUEI, (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentAndValueNonNull(event, "instance");
        event = item.getEventForState(ThresholdEvaluatorState.Status.RE_ARMED, new Date(), 94.0, null);
        Assert.assertEquals((String)"UEI should be the uei.opennms.org/custom/thresholdRearmed", (Object)rearmedUEI, (Object)event.getUei());
        ThresholdEvaluatorHighLowTest.parmPresentAndValueNonNull(event, "instance");
    }
}

