/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import com.google.common.annotations.VisibleForTesting;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.threshd.api.ThresholdingEventProxy;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdingEventProxyImpl
implements ThresholdingEventProxy {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdingEventProxy.class);
    private EventProxy eventMgr;

    public void sendEvent(Event event) {
        try {
            this.eventMgr.send(event);
        }
        catch (EventProxyException e) {
            LOG.error("Failed to send {} ", (Object)event, (Object)e);
        }
    }

    public void send(Event event) throws EventProxyException {
        this.eventMgr.send(event);
    }

    public void send(Log eventLog) throws EventProxyException {
        this.eventMgr.send(eventLog);
    }

    @VisibleForTesting
    public void setEventMgr(EventProxy eventMgr) {
        this.eventMgr = eventMgr;
    }
}

