/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorHighLow;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRearmingAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRelativeChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.api.ThresholdingEventProxy;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThresholdEntity
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdEntity.class);
    private static List<ThresholdEvaluator> s_thresholdEvaluators = new LinkedList<ThresholdEvaluator>();
    private Map<String, List<ThresholdEvaluatorState>> m_thresholdEvaluatorStates = new HashMap<String, List<ThresholdEvaluatorState>>();
    private ThresholdingEventProxy m_thresholdingEventProxy;

    public ThresholdEntity() {
        this.m_thresholdEvaluatorStates.put(null, new LinkedList());
    }

    public BaseThresholdDefConfigWrapper getThresholdConfig() {
        return this.m_thresholdEvaluatorStates.get(null).get(0).getThresholdConfig();
    }

    private boolean hasThresholds() {
        return this.m_thresholdEvaluatorStates.get(null).size() != 0;
    }

    public String getDataSourceExpression() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getDatasourceExpression();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public String getDatasourceType() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getDsType();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public String getDatasourceLabel() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getDsLabel().orElse(null);
        }
        return null;
    }

    public Collection<String> getRequiredDatasources() {
        if (this.hasThresholds()) {
            HashSet<String> dataSources = new HashSet<String>();
            dataSources.addAll(this.getThresholdConfig().getRequiredDatasources());
            dataSources.addAll(this.getThresholdConfig().getFilterDatasources());
            return dataSources;
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public ThresholdEntity clone() {
        ThresholdEntity clone = new ThresholdEntity();
        for (ThresholdEvaluatorState thresholdItem : this.getThresholdEvaluatorStates(null)) {
            clone.addThreshold(thresholdItem.getThresholdConfig());
        }
        return clone;
    }

    public String toString() {
        if (!this.hasThresholds()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("evaluator=").append(this.getThresholdConfig().getType());
        buffer.append(", dsName=").append(this.getDataSourceExpression());
        buffer.append(", dsType=").append(this.getDatasourceType());
        buffer.append(", evaluators=[");
        for (ThresholdEvaluatorState item : this.getThresholdEvaluatorStates(null)) {
            buffer.append("{ds=").append(item.getThresholdConfig().getDatasourceExpression());
            buffer.append(", value=").append(item.getThresholdConfig().getValue());
            buffer.append(", rearm=").append(item.getThresholdConfig().getRearm());
            buffer.append(", trigger=").append(item.getThresholdConfig().getTrigger());
            buffer.append("}");
        }
        buffer.append("]}");
        return buffer.toString();
    }

    public List<Event> evaluateAndCreateEvents(Map<String, Double> values, Date date) {
        return this.evaluateAndCreateEvents(null, values, date);
    }

    public List<Event> evaluateAndCreateEvents(CollectionResourceWrapper resource, Map<String, Double> values, Date date) {
        LinkedList<Event> events = new LinkedList<Event>();
        double dsValue = 0.0;
        String instance = null;
        if (resource != null) {
            instance = resource.getInstanceLabel();
        }
        try {
            if (this.getThresholdEvaluatorStates(instance).size() <= 0) {
                throw new IllegalStateException("No thresholds have been added.");
            }
            dsValue = this.getThresholdConfig().evaluate(values);
        }
        catch (ThresholdExpressionException e) {
            LOG.warn("Failed to evaluate: ", (Throwable)e);
            return events;
        }
        LOG.debug("evaluate: value= {} against threshold: {}", (Object)dsValue, (Object)this);
        for (ThresholdEvaluatorState item : this.getThresholdEvaluatorStates(instance)) {
            ThresholdEvaluatorState.Status status;
            Event event = item.getEventForState(status = item.evaluate(dsValue), date, dsValue, resource);
            if (event == null) continue;
            events.add(event);
        }
        return events;
    }

    public void addThreshold(BaseThresholdDefConfigWrapper threshold) {
        ThresholdEvaluator evaluator = this.getEvaluatorForThreshold(threshold);
        List<ThresholdEvaluatorState> defaultList = this.m_thresholdEvaluatorStates.get(null);
        for (ThresholdEvaluatorState item : defaultList) {
            if (!threshold.getType().equals((Object)item.getThresholdConfig().getType())) continue;
            throw new IllegalStateException(threshold.getType() + " threshold already set.");
        }
        defaultList.add(evaluator.getThresholdEvaluatorState(threshold));
    }

    private ThresholdEvaluator getEvaluatorForThreshold(BaseThresholdDefConfigWrapper threshold) {
        for (ThresholdEvaluator evaluator : ThresholdEntity.getThresholdEvaluators()) {
            if (!evaluator.supportsType(threshold.getType())) continue;
            return evaluator;
        }
        String message = "Threshold type '" + threshold.getType() + "' for " + threshold.getDatasourceExpression() + " is not supported";
        LOG.warn(message);
        throw new IllegalArgumentException(message);
    }

    public List<ThresholdEvaluatorState> getThresholdEvaluatorStates(String instance) {
        List<ThresholdEvaluatorState> result = this.m_thresholdEvaluatorStates.get(instance);
        if (result == null) {
            List<ThresholdEvaluatorState> defaultList = this.m_thresholdEvaluatorStates.get(null);
            result = new LinkedList<ThresholdEvaluatorState>();
            for (ThresholdEvaluatorState state : defaultList) {
                result.add(state.getCleanClone());
            }
            this.m_thresholdEvaluatorStates.put(instance == null ? null : instance.intern(), result);
        }
        return result;
    }

    public void merge(ThresholdEntity entity) {
        if (!this.getThresholdConfig().equals(entity.getThresholdConfig())) {
            this.sendRearmForTriggeredStates();
            this.getThresholdConfig().merge(entity.getThresholdConfig());
        }
    }

    public void delete() {
        this.sendRearmForTriggeredStates();
    }

    private void sendRearmForTriggeredStates() {
        for (String instance : this.m_thresholdEvaluatorStates.keySet()) {
            for (ThresholdEvaluatorState state : this.m_thresholdEvaluatorStates.get(instance)) {
                if (!state.isTriggered()) continue;
                Event e = state.getEventForState(ThresholdEvaluatorState.Status.RE_ARMED, new Date(), Double.NaN, null);
                Parm p = new Parm();
                p.setParmName("reason");
                Value v = new Value();
                v.setContent("Configuration has been changed");
                p.setValue(v);
                e.addParm(p);
                LOG.info("sendRearmForTriggeredStates: sending rearm for {}", (Object)e);
                this.m_thresholdingEventProxy.sendEvent(e);
                state.clearState();
            }
        }
    }

    public static final List<ThresholdEvaluator> getThresholdEvaluators() {
        return s_thresholdEvaluators;
    }

    public void setEventProxy(ThresholdingEventProxy eventProxy) {
        this.m_thresholdingEventProxy = eventProxy;
    }

    static {
        s_thresholdEvaluators.add(new ThresholdEvaluatorHighLow());
        s_thresholdEvaluators.add(new ThresholdEvaluatorRelativeChange());
        s_thresholdEvaluators.add(new ThresholdEvaluatorAbsoluteChange());
        s_thresholdEvaluators.add(new ThresholdEvaluatorRearmingAbsoluteChange());
    }
}

