/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.threshd.api.ThresholdingEventProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultThresholdsDao
implements ThresholdsDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultThresholdsDao.class);
    private ThresholdingConfigFactory m_thresholdingConfigFactory;
    private ThresholdingEventProxy m_eventProxy;

    @Override
    public ThresholdGroup get(String name) {
        return this.get(name, null);
    }

    @Override
    public ThresholdGroup merge(ThresholdGroup group) {
        return this.get(group.getName(), group);
    }

    private ThresholdGroup get(String name, ThresholdGroup group) {
        boolean merge = group != null;
        ThresholdGroup newGroup = new ThresholdGroup(name);
        File rrdRepository = new File(this.getThresholdingConfigFactory().getRrdRepository(name));
        newGroup.setRrdRepository(rrdRepository);
        ThresholdResourceType nodeType = this.getThresholdResourceType(name, "node", merge ? group.getNodeResourceType() : null);
        newGroup.setNodeResourceType(nodeType);
        ThresholdResourceType ifType = this.getThresholdResourceType(name, "if", merge ? group.getIfResourceType() : null);
        newGroup.setIfResourceType(ifType);
        for (Basethresholddef thresh : this.getThresholdingConfigFactory().getThresholds(name)) {
            ThresholdResourceType genericType;
            String id = thresh.getDsType();
            if (id.equals("if") || id.equals("node") || newGroup.getGenericResourceTypeMap().containsKey(id) || (genericType = this.getThresholdResourceType(name, id, merge ? group.getGenericResourceTypeMap().get(id) : null)).getThresholdMap().size() <= 0) continue;
            LOG.info("Adding {}::{} with {} elements", new Object[]{name, id, genericType.getThresholdMap().size()});
            newGroup.getGenericResourceTypeMap().put(id, genericType);
        }
        return newGroup;
    }

    private ThresholdResourceType getThresholdResourceType(String groupName, String typeName, ThresholdResourceType type) {
        ThresholdResourceType resourceType = new ThresholdResourceType(typeName);
        Map<String, Set<ThresholdEntity>> thresholdMap = null;
        if (type == null) {
            thresholdMap = new HashMap<String, Set<ThresholdEntity>>();
            this.fillThresholdStateMap(groupName, typeName, thresholdMap);
        } else {
            thresholdMap = type.getThresholdMap();
            this.fillThresholdStateMap(groupName, type.getDsType(), thresholdMap);
        }
        resourceType.setThresholdMap(thresholdMap);
        return resourceType;
    }

    private void fillThresholdStateMap(String groupName, String typeName, Map<String, Set<ThresholdEntity>> thresholdMap) {
        boolean merge = !thresholdMap.isEmpty();
        for (Basethresholddef basethresholddef : this.getThresholdingConfigFactory().getThresholds(groupName)) {
            if (!basethresholddef.getDsType().equals(typeName)) continue;
            try {
                BaseThresholdDefConfigWrapper wrapper = BaseThresholdDefConfigWrapper.getConfigWrapper(basethresholddef);
                Set<ThresholdEntity> thresholdEntitySet = thresholdMap.get(wrapper.getDatasourceExpression());
                if (thresholdEntitySet == null) {
                    thresholdEntitySet = new LinkedHashSet<ThresholdEntity>();
                    thresholdMap.put(wrapper.getDatasourceExpression(), thresholdEntitySet);
                }
                try {
                    ThresholdEntity thresholdEntity = new ThresholdEntity();
                    thresholdEntity.setEventProxy(this.m_eventProxy);
                    thresholdEntity.addThreshold(wrapper);
                    if (merge) {
                        boolean updated = false;
                        for (ThresholdEntity e : thresholdEntitySet) {
                            if (!thresholdEntity.getThresholdConfig().equals(e.getThresholdConfig())) continue;
                            e.merge(thresholdEntity);
                            updated = true;
                        }
                        if (updated) continue;
                        thresholdEntitySet.add(thresholdEntity);
                        continue;
                    }
                    thresholdEntitySet.add(thresholdEntity);
                }
                catch (IllegalStateException e) {
                    LOG.warn("fillThresholdStateMap: Encountered duplicate {} for datasource {}", new Object[]{basethresholddef.getType(), wrapper.getDatasourceExpression(), e});
                }
            }
            catch (ThresholdExpressionException e) {
                LOG.warn("fillThresholdStateMap: Could not parse threshold expression", (Throwable)e);
            }
        }
        if (merge) {
            LOG.debug("fillThresholdStateMap(merge): checking if definitions that are no longer exist for group {} using type {}", (Object)groupName, (Object)typeName);
            for (Map.Entry entry : thresholdMap.entrySet()) {
                Set value = (Set)entry.getValue();
                Iterator thresholdIterator = value.iterator();
                while (thresholdIterator.hasNext()) {
                    ThresholdEntity entity = (ThresholdEntity)thresholdIterator.next();
                    boolean found = false;
                    for (Basethresholddef thresh : this.getThresholdingConfigFactory().getThresholds(groupName)) {
                        BaseThresholdDefConfigWrapper newConfig = null;
                        try {
                            newConfig = BaseThresholdDefConfigWrapper.getConfigWrapper(thresh);
                        }
                        catch (ThresholdExpressionException e) {
                            LOG.warn("fillThresholdStateMap: Could not parse threshold expression", (Throwable)e);
                        }
                        if (newConfig == null || !newConfig.equals(entity.getThresholdConfig())) continue;
                        found = true;
                    }
                    if (found) continue;
                    LOG.info("fillThresholdStateMap(merge): deleting entity {}", (Object)entity);
                    entity.delete();
                    thresholdIterator.remove();
                }
            }
        }
    }

    @Override
    public ThresholdingConfigFactory getThresholdingConfigFactory() {
        return this.m_thresholdingConfigFactory;
    }

    public void setThresholdingConfigFactory(ThresholdingConfigFactory thresholdingConfigFactory) {
        this.m_thresholdingConfigFactory = thresholdingConfigFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_thresholdingConfigFactory != null ? 1 : 0) != 0, (String)"thresholdingConfigFactory property not set");
    }

    public void setEventProxy(ThresholdingEventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }
}

