/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.ThresholdInitializationException;
import org.opennms.netmgt.threshd.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.ThresholdingService;
import org.opennms.netmgt.threshd.ThresholdingSession;
import org.opennms.netmgt.threshd.ThresholdingSessionImpl;
import org.opennms.netmgt.threshd.ThresholdingSessionKey;
import org.opennms.netmgt.threshd.ThresholdingSetImpl;
import org.opennms.netmgt.threshd.ThresholdingSetPersister;
import org.opennms.netmgt.threshd.ThresholdingVisitorImpl;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ThresholdingServiceImpl
implements ThresholdingService,
EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdingServiceImpl.class);
    public static final List<String> UEI_LIST = Lists.newArrayList((Object[])new String[]{"uei.opennms.org/nodes/nodeGainedService", "uei.opennms.org/nodes/nodeCategoryMembershipChanged", "uei.opennms.org/internal/reloadDaemonConfig", "uei.opennms.org/internal/thresholdConfigChange"});
    @Autowired
    private ThresholdingEventProxy eventProxy;
    @Autowired
    private ThresholdingSetPersister thresholdingSetPersister;
    @Autowired
    private ResourceStorageDao resourceStorageDao;
    @Autowired
    private EventIpcManager eventIpcManager;

    @PostConstruct
    private void init() {
        try {
            ThreshdConfigFactory.init();
            ThresholdingConfigFactory.init();
            this.eventIpcManager.addEventListener((EventListener)this, UEI_LIST);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize thresholding.", e);
        }
    }

    public String getName() {
        return "ThresholdingService";
    }

    public void onEvent(Event e) {
        switch (e.getUei()) {
            case "uei.opennms.org/nodes/nodeGainedService": {
                this.nodeGainedService(e);
                break;
            }
            case "uei.opennms.org/nodes/nodeCategoryMembershipChanged": {
                this.handleNodeCategoryChanged(e);
                break;
            }
            case "uei.opennms.org/internal/reloadDaemonConfig": {
                this.daemonReload(e);
                break;
            }
            case "uei.opennms.org/internal/thresholdConfigChange": {
                this.reinitializeThresholdingSets(e);
                break;
            }
            default: {
                LOG.debug("Unexpected Event for Thresholding: {}", (Object)e);
            }
        }
    }

    public void nodeGainedService(Event event) {
        LOG.debug(event.toString());
        ThreshdConfigFactory.getInstance().rebuildPackageIpListMap();
        this.reinitializeThresholdingSets(event);
    }

    public void handleNodeCategoryChanged(Event event) {
        LOG.debug(event.toString());
        ThreshdConfigFactory.getInstance().rebuildPackageIpListMap();
        this.reinitializeThresholdingSets(event);
    }

    @Override
    public ThresholdingSession createSession(int nodeId, String hostAddress, String serviceName, RrdRepository repository, ServiceParameters serviceParams) throws ThresholdInitializationException {
        Objects.requireNonNull(repository, "RrdRepository must not be null");
        Objects.requireNonNull(serviceParams, "ServiceParameters must not be null");
        String resource = "";
        if (repository.getRrdBaseDir() != null && repository.getRrdBaseDir().getPath() != null) {
            resource = repository.getRrdBaseDir().getPath();
        }
        ThresholdingSessionKey sessionKey = new ThresholdingSessionKey(nodeId, hostAddress, serviceName, resource);
        return new ThresholdingSessionImpl(this, sessionKey, this.resourceStorageDao, repository, serviceParams);
    }

    public ThresholdingVisitorImpl getThresholdingVistor(ThresholdingSession session) throws ThresholdInitializationException {
        ThresholdingSetImpl thresholdingSet = (ThresholdingSetImpl)this.thresholdingSetPersister.getThresholdingSet(session, this.eventProxy);
        return new ThresholdingVisitorImpl(thresholdingSet, ((ThresholdingSessionImpl)session).getResourceDao(), this.eventProxy);
    }

    public EventIpcManager getEventIpcManager() {
        return this.eventIpcManager;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.eventIpcManager = eventIpcManager;
    }

    public ThresholdingEventProxy getEventProxy() {
        return this.eventProxy;
    }

    public void setEventProxy(ThresholdingEventProxy eventProxy) {
        this.eventProxy = eventProxy;
    }

    public ThresholdingSetPersister getThresholdingSetPersister() {
        return this.thresholdingSetPersister;
    }

    public void setThresholdingSetPersister(ThresholdingSetPersister thresholdingSetPersister) {
        this.thresholdingSetPersister = thresholdingSetPersister;
    }

    public void close(ThresholdingSessionImpl session) {
        this.thresholdingSetPersister.clear(session);
    }

    private void daemonReload(Event event) {
        String thresholdsDaemonName = "Threshd";
        boolean isThresholds = false;
        for (Parm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Threshd".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isThresholds = true;
            break;
        }
        if (isThresholds) {
            try {
                ThreshdConfigFactory.reload();
                ThresholdingConfigFactory.reload();
                this.thresholdingSetPersister.reinitializeThresholdingSets();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to reload thresholding.", e);
            }
        }
    }

    private void reinitializeThresholdingSets(Event e) {
        this.thresholdingSetPersister.reinitializeThresholdingSets();
    }
}

