/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.threshd.ThresholdInitializationException;
import org.opennms.netmgt.threshd.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.ThresholdingSession;
import org.opennms.netmgt.threshd.ThresholdingSessionImpl;
import org.opennms.netmgt.threshd.ThresholdingSessionKey;
import org.opennms.netmgt.threshd.ThresholdingSet;
import org.opennms.netmgt.threshd.ThresholdingSetImpl;
import org.opennms.netmgt.threshd.ThresholdingSetPersister;

public class DefaultThresholdingSetPersister
implements ThresholdingSetPersister {
    private Map<ThresholdingSessionKey, ThresholdingSetImpl> thresholdingSets = new HashMap<ThresholdingSessionKey, ThresholdingSetImpl>();

    @Override
    public void persistSet(ThresholdingSession session, ThresholdingSet set) {
        this.thresholdingSets.put(((ThresholdingSessionImpl)session).getKey(), (ThresholdingSetImpl)set);
    }

    @Override
    public ThresholdingSet getThresholdingSet(ThresholdingSession session, ThresholdingEventProxy eventProxy) throws ThresholdInitializationException {
        ThresholdingSessionKey key = ((ThresholdingSessionImpl)session).getKey();
        ThresholdingSetImpl tSet = this.thresholdingSets.get(key);
        if (tSet == null) {
            tSet = new ThresholdingSetImpl(key.getNodeId(), key.getLocation(), key.getServiceName(), ((ThresholdingSessionImpl)session).getRrdRepository(), ((ThresholdingSessionImpl)session).getServiceParameters(), ((ThresholdingSessionImpl)session).getResourceDao(), eventProxy);
            this.thresholdingSets.put(key, tSet);
        }
        return tSet;
    }

    @Override
    public void reinitializeThresholdingSets() {
        this.thresholdingSets.values().forEach(set -> set.reinitialize());
    }

    @Override
    public void clear(ThresholdingSession session) {
        ThresholdingSessionKey key = ((ThresholdingSessionImpl)session).getKey();
        this.thresholdingSets.remove(key);
    }
}

