/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.ResourceFilter;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.config.threshd.ThresholdType;
import org.opennms.netmgt.threshd.ExpressionConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdExpressionException;

public abstract class BaseThresholdDefConfigWrapper {
    Basethresholddef m_baseDef;

    protected BaseThresholdDefConfigWrapper(Basethresholddef baseDef) {
        this.m_baseDef = baseDef;
    }

    public static BaseThresholdDefConfigWrapper getConfigWrapper(Basethresholddef baseDef) throws ThresholdExpressionException {
        if (baseDef instanceof Threshold) {
            return new ThresholdConfigWrapper((Threshold)baseDef);
        }
        if (baseDef instanceof Expression) {
            return new ExpressionConfigWrapper((Expression)baseDef);
        }
        return null;
    }

    public List<String> getFilterDatasources() {
        ArrayList<String> dataSources = new ArrayList<String>();
        for (ResourceFilter s : this.getBasethresholddef().getResourceFilters()) {
            dataSources.add(s.getField());
        }
        return dataSources;
    }

    public abstract String getDatasourceExpression();

    public abstract Collection<String> getRequiredDatasources();

    public abstract double evaluate(Map<String, Double> var1) throws ThresholdExpressionException;

    public String getDsType() {
        return this.m_baseDef.getDsType();
    }

    public Optional<String> getDsLabel() {
        return this.m_baseDef.getDsLabel();
    }

    public double getRearm() {
        return this.m_baseDef.getRearm();
    }

    public int getTrigger() {
        return this.m_baseDef.getTrigger();
    }

    public ThresholdType getType() {
        return this.m_baseDef.getType();
    }

    public double getValue() {
        return this.m_baseDef.getValue();
    }

    public boolean hasRearm() {
        return this.m_baseDef.getRearm() != null;
    }

    public boolean hasTrigger() {
        return this.m_baseDef.getTrigger() != null;
    }

    public boolean hasValue() {
        return this.m_baseDef.getValue() != null;
    }

    public Optional<String> getTriggeredUEI() {
        return this.m_baseDef.getTriggeredUEI();
    }

    public Optional<String> getRearmedUEI() {
        return this.m_baseDef.getRearmedUEI();
    }

    public Basethresholddef getBasethresholddef() {
        return this.m_baseDef;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaseThresholdDefConfigWrapper) {
            BaseThresholdDefConfigWrapper that = (BaseThresholdDefConfigWrapper)obj;
            return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getDsType(), that.getDsType()) && Objects.equals(this.getDatasourceExpression(), that.getDatasourceExpression()) && Objects.equals(this.getDsLabel(), that.getDsLabel()) && Objects.equals(this.getTriggeredUEI(), that.getTriggeredUEI()) && Objects.equals(this.getRearmedUEI(), that.getRearmedUEI()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getRearm(), that.getRearm()) && Objects.equals(this.getTrigger(), that.getTrigger()) && Objects.equals(this.getBasethresholddef().getFilterOperator(), that.getBasethresholddef().getFilterOperator()) && Objects.equals(this.getBasethresholddef().getRelaxed(), that.getBasethresholddef().getRelaxed()) && Objects.equals(this.getBasethresholddef().getResourceFilters(), that.getBasethresholddef().getResourceFilters());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_baseDef);
    }

    public void merge(BaseThresholdDefConfigWrapper threshold) {
        this.m_baseDef = threshold.getBasethresholddef();
    }
}

