/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.test.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.dto.CollectionAgentDTO;
import org.opennms.netmgt.collection.support.DefaultServiceCollectorRegistry;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class CollectorComplianceTest {
    private final Class<? extends ServiceCollector> collectorClass;
    private final boolean runsOnMinion;
    private ServiceCollectorRegistry serviceCollectorRegistry = new DefaultServiceCollectorRegistry();

    public CollectorComplianceTest(Class<? extends ServiceCollector> collectorClass, boolean runsOnMinion) {
        this.collectorClass = collectorClass;
        this.runsOnMinion = runsOnMinion;
    }

    public abstract String getCollectionName();

    public abstract Map<String, Object> getRequiredParameters();

    public void beforeMinion() {
    }

    public void afterMinion() {
    }

    public Map<String, Object> getRequiredBeans() {
        return Collections.emptyMap();
    }

    @Test
    public void isAvailableInDefaultRegistry() {
        Assert.assertNotNull((String)(this.collectorClass.getCanonicalName() + " was not found in the default registry."), (Object)this.getCollector());
    }

    @Test
    public void canInitializeManyTimes() throws CollectionInitializationException {
        ServiceCollector collector = this.getCollector();
        this.initialize(collector);
        this.initialize(collector);
        this.initialize(collector);
    }

    @Test
    public void canCollectUsingOpenNMSWorkflow() throws CollectionInitializationException, CollectionException {
        OnmsNode node = (OnmsNode)Mockito.mock(OnmsNode.class);
        OnmsIpInterface iface = (OnmsIpInterface)Mockito.mock(OnmsIpInterface.class);
        Mockito.when((Object)iface.getNode()).thenReturn((Object)node);
        Mockito.when((Object)iface.getIpAddress()).thenReturn((Object)InetAddrUtils.getLocalHostAddress());
        IpInterfaceDao ifaceDao = (IpInterfaceDao)Mockito.mock(IpInterfaceDao.class);
        Mockito.when((Object)ifaceDao.load((Serializable)Integer.valueOf(1))).thenReturn((Object)iface);
        PlatformTransactionManager transMgr = (PlatformTransactionManager)Mockito.mock(PlatformTransactionManager.class);
        SnmpCollectionAgent agent = DefaultCollectionAgent.create((Integer)1, (IpInterfaceDao)ifaceDao, (PlatformTransactionManager)transMgr);
        ServiceCollector opennmsCollector = this.getCollector();
        this.initialize(opennmsCollector);
        String targetLocation = "!Default";
        opennmsCollector.getEffectiveLocation("!Default");
        Map<String, Object> requiredParams = this.getRequiredParameters();
        Map runtimeAttrs = opennmsCollector.getRuntimeAttributes((CollectionAgent)agent, Collections.unmodifiableMap(requiredParams));
        HashMap<String, Object> allParms = new HashMap<String, Object>();
        allParms.putAll(requiredParams);
        allParms.putAll(runtimeAttrs);
        CollectionSet collectionSet = opennmsCollector.collect((CollectionAgent)agent, Collections.unmodifiableMap(allParms));
        Assert.assertEquals((Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        Assert.assertNotNull((Object)opennmsCollector.getRrdRepository(this.getCollectionName()));
    }

    @Test
    public void canCollectUsingMinionWorkflow() throws CollectionInitializationException, CollectionException {
        Assume.assumeTrue((boolean)this.runsOnMinion);
        OnmsNode node = (OnmsNode)Mockito.mock(OnmsNode.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)1);
        OnmsIpInterface iface = (OnmsIpInterface)Mockito.mock(OnmsIpInterface.class);
        Mockito.when((Object)iface.getNode()).thenReturn((Object)node);
        Mockito.when((Object)iface.getIpAddress()).thenReturn((Object)InetAddrUtils.getLocalHostAddress());
        IpInterfaceDao ifaceDao = (IpInterfaceDao)Mockito.mock(IpInterfaceDao.class);
        Mockito.when((Object)ifaceDao.load((Serializable)Integer.valueOf(1))).thenReturn((Object)iface);
        PlatformTransactionManager transMgr = (PlatformTransactionManager)Mockito.mock(PlatformTransactionManager.class);
        SnmpCollectionAgent agent = DefaultCollectionAgent.create((Integer)1, (IpInterfaceDao)ifaceDao, (PlatformTransactionManager)transMgr);
        ServiceCollector opennmsCollector = this.getCollector();
        this.initialize(opennmsCollector);
        String targetLocation = "!Default";
        Assert.assertEquals((String)"Location cannot be altered.", (Object)"!Default", (Object)opennmsCollector.getEffectiveLocation("!Default"));
        Map<String, Object> requiredParams = this.getRequiredParameters();
        Map runtimeAttrs = opennmsCollector.getRuntimeAttributes((CollectionAgent)agent, Collections.unmodifiableMap(requiredParams));
        HashMap<String, Object> allParms = new HashMap<String, Object>();
        allParms.putAll(requiredParams);
        allParms.putAll(runtimeAttrs);
        Map marshaledParms = opennmsCollector.marshalParameters(Collections.unmodifiableMap(allParms));
        this.beforeMinion();
        ServiceCollector minionCollector = this.getNewCollector();
        Map unmarshaledParms = minionCollector.unmarshalParameters(Collections.unmodifiableMap(marshaledParms));
        CollectionAgentDTO agentDTO = new CollectionAgentDTO((CollectionAgent)agent);
        CollectionSet collectionSet = minionCollector.collect((CollectionAgent)agentDTO, Collections.unmodifiableMap(unmarshaledParms));
        Assert.assertEquals((Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        this.afterMinion();
        JaxbUtils.marshal((Object)collectionSet);
        Assert.assertNotNull((Object)opennmsCollector.getRrdRepository(this.getCollectionName()));
    }

    private ServiceCollector getCollector() {
        return this.serviceCollectorRegistry.getCollectorByClassName(this.collectorClass.getCanonicalName());
    }

    private ServiceCollector getNewCollector() {
        try {
            return this.collectorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void initialize(ServiceCollector collector) throws CollectionInitializationException {
        ApplicationContext context = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        this.getRequiredBeans().forEach((k, v) -> Mockito.when((Object)context.getBean(k)).thenReturn(v));
        BeanUtils.setStaticApplicationContext((ApplicationContext)context);
        collector.initialize();
        BeanUtils.setStaticApplicationContext(null);
    }
}

