/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Date;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.collectd.AbstractSnmpCollector;
import org.opennms.netmgt.collectd.ForceRescanState;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collectd.SnmpCollectionSetToCollectionSetDTOConverter;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.InvalidCollectionAgentException;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpCollectorNG
extends AbstractSnmpCollector {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpCollectorNG.class);

    @Override
    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        try {
            ServiceParameters params = new ServiceParameters(parameters);
            params.logIfAliasConfig();
            if (this.m_client == null) {
                this.m_client = (LocationAwareSnmpClient)BeanUtils.getBean((String)"daoContext", (String)"locationAwareSnmpClient", LocationAwareSnmpClient.class);
            }
            if (!(agent instanceof SnmpCollectionAgent)) {
                throw new InvalidCollectionAgentException(String.format("Expected agent of type: %s, but got: %s", SnmpCollectionAgent.class.getCanonicalName(), agent.getClass().getCanonicalName()));
            }
            OnmsSnmpCollection snmpCollection = new OnmsSnmpCollection((SnmpCollectionAgent)agent, params, this.m_client);
            EventIpcManager eventProxy = EventIpcManagerFactory.getIpcManager();
            ForceRescanState forceRescanState = new ForceRescanState(agent, (EventProxy)eventProxy);
            SnmpCollectionSet collectionSet = new SnmpCollectionSet((SnmpCollectionAgent)agent, snmpCollection, snmpCollection.getClient());
            collectionSet.setCollectionTimestamp(new Date());
            if (!collectionSet.hasDataToCollect()) {
                LOG.info("agent {} defines no data to collect.  Skipping.", (Object)agent);
            }
            collectionSet.collect();
            if (System.getProperty("org.opennms.netmgt.collectd.SnmpCollector.forceRescan", "false").equalsIgnoreCase("true") && collectionSet.rescanNeeded()) {
                forceRescanState.rescanIndicated();
            } else {
                collectionSet.checkForSystemRestart();
            }
            return new SnmpCollectionSetToCollectionSetDTOConverter().withParameters(params).convert(collectionSet);
        }
        catch (CollectionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CollectionException("Unexpected error during node SNMP collection for: " + agent.getHostAddress(), t);
        }
    }
}

